/*******************************************************************************
 * @note Copyright (C) 2020 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file Key.h
 * @brief
 *
 * @history - Vxx.xx ,Date :
*******************************************************************************/

#ifndef _KEY_SCAN_H_
#define _KEY_SCAN_H_

#define   KEY1_STATUS         GPIOA->IDR&GPIO_Pin_2
#define   KEY2_STATUS         GPIOA->IDR&GPIO_Pin_3
#define   KEY3_STATUS         GPIOB->IDR&GPIO_Pin_0

enum
{
  KEY1 = 0x01,
  KEY2 = 0x02,
  KEY3 = 0x04  
};

#define   KEY_DEBOUNCE_TIME       1000

extern uint8_t ucKey_RD;
extern uint8_t ucADC_Level;

/**
 * @brief Key Init
 * @param[in] <none>
 * @return none
 */
void Key_Init(void);

/**
 * @brief get key value to judge which key is pressed
 * @param[in] <none>
 * @return ucKey_D value : 0x01:Key1 | 0x02:Key2 | 0x04:Key3
 */
uint8_t Key_Rd(void);

/**
 * @brief scan to judge which key is pressed : when key status changed ,set DATA_READY as TRUE
 * @param[in] <none>
 * @return none
 */
void Key_Scan(void);

#endif

/****************************************end of file**********************************************/