/*******************************************************************************
 * @note Copyright (C) 2020 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file APP.h
 * @brief
 *
 * @history - Vxx.xx ,Date :
*******************************************************************************/

#ifndef _APP_H_
#define _APP_H_

#include "RFAPI.h"
#define     UART_BOUNDRATE          19200
#define     TRX_PIN_MODE            GPIOA->IDR&GPIO_Pin_4

enum  APP_STATE
{
     FUNCTION_TX,  
     FUNCTION_RX,
};

enum  APP_TXB_Status
{
    MODE_NULL,
    MODE_TX_SINGLE,
    MODE_TX_1000PACK,
    MODE_TX_CONTINUE
};

extern unsigned char Work_State;
extern unsigned char DISP_Status;
extern unsigned char ucTXMode;
extern bool DATA_READY, TIME_8MS, RX_READY,DATA_READY_ADC;
extern bool TX_RQ,TX_TIME;
extern uint8_t   ucTest_Mode;

/**
 * @brief TX/RX Work Application
 * @param[in] <none>
 * @return none
 */
void  APP_StateMachine(void);

/**
 * @brief RX StateMachine
 * @param[in] <none>
 * @return none
 */
void APP_RX_Normal(void);

/**
 * @brief TX StateMachine
 * @param[in] <none>
 * @return none
 */
void APP_TX_Normal(void);

#endif

/******************************End of file************************************/