/*******************************************************************************
 * @note Copyright (C) 2020 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file LED.h
 * @brief
 *
 * @history - Vxx.xx ,Date :
*******************************************************************************/
#ifndef   _LED_H_
#define   _LED_H_

#include "stm8l15x.h"

#define         LED_BIT0_ON              GPIOD->ODR &= (~GPIO_Pin_1)
#define         LED_BIT0_OFF             GPIOD->ODR |= GPIO_Pin_1
#define         LED_BIT1_ON              GPIOC->ODR &= (~GPIO_Pin_4)
#define         LED_BIT1_OFF             GPIOC->ODR |= GPIO_Pin_4
#define         LED_BIT2_ON              GPIOC->ODR &= (~GPIO_Pin_5)
#define         LED_BIT2_OFF             GPIOC->ODR |= GPIO_Pin_5
#define         LED_BIT3_ON              GPIOC->ODR &= (~GPIO_Pin_6)
#define         LED_BIT3_OFF             GPIOC->ODR |= GPIO_Pin_6

#define         CH595_DAT_SET            GPIOD->ODR |= GPIO_Pin_4
#define         CH595_DAT_RESET          GPIOD->ODR &= (~GPIO_Pin_4)
#define         CH595_CLK_SET            GPIOA->ODR |= GPIO_Pin_5
#define         CH595_CLK_RESET          GPIOA->ODR &= (~GPIO_Pin_5)
#define         CH595_CP_SET             GPIOB->ODR |= GPIO_Pin_3
#define         CH595_CP_RESET           GPIOB->ODR &= (~GPIO_Pin_3)

#define         LED2_ON                  GPIOB->ODR |= GPIO_Pin_2
#define         LED2_OFF                 GPIOB->ODR &= (~GPIO_Pin_2)
#define         LED3_ON                  GPIOD->ODR |= GPIO_Pin_2
#define         LED3_OFF                 GPIOD->ODR &= (~GPIO_Pin_2)  

enum
{
    ZERO,
    ONE,
    TWO,
    THREE,
    FOUR,
    FIVE,
    SIX,
    SEVEN,
    EIGHT,
    NINE,
    SUB,
    LED_NULL,
    LED_E,
    LED_R,
    LED_CP,
    LED_8p,
    LED_F,
    LED_A,
    LED_B,
    LED_C,
    LED_h,
    LETTER_H
    
};

enum
{
    LED_CHANNEL_MODE,
    LED_FUNCTION_MODE,
    LED_CNT_MODE,
    LED_OTHER_MODE
};


extern unsigned char ucLED_FlashCnt;
extern bool bLED_Enable;

/**
 * @brief LED init :Init LED pin and CH595 pin
 * @param[in] <none>
 * @return none
 */
void LED_Init(void);

/**
 * @brief write ucData into HC595
 * @param[in] <none>
 * @return none
 */
void HC595_Write(unsigned char ucData);

/**
 * @brief LED Display
 * @param[in] <none>
 * @return none
 */
void LED_Display(void);

/**
 * @brief LED Display font modification:change LED display font
 * @param[in] <none>
 * @return none
 */
void LED_ChangeFont(unsigned short usLED_Data,unsigned char ucLED_Mode);

#endif


/*********************************End of file***********************************/