#include "stm8l15x.h"
#include "LED.h"
#include "Key.h"
#include "App.h"
#include "appsub.h"
#include "stm8l15x_tim2.h"
#include "stm8l15x_tim3.h"
#include "stm8l15x_dma.h"
#include "stm8l15x_usart.h"
#include "stdio.h"
#include "CPU.H"
#include "VCPU.H"

#include "BIOS.H"

unsigned char Work_State;
uint8_t   ucTest_Mode ;

/**
 * @brief Oscillator Init
 * @param[in] <none>
 * @return none
 */
void Oscillator_Init(void)
{
    CLK_DeInit();
    CLK_HSICmd(ENABLE);
    CLK_SYSCLKDivConfig(CLK_SYSCLKDiv_1);
    CLK_ClockSecuritySystemEnable();
}

/**
 * @brief GPIO PORT Init
 * @param[in] <none>
 * @return none
 */
void  IO_Init(void)
{
    GPIO_DeInit(GPIOA);  
    GPIO_DeInit(GPIOB);   
    GPIO_DeInit(GPIOC);   
    GPIO_DeInit(GPIOD);
    
    /*TXRX Selec IO */
    GPIO_Init( GPIOA, GPIO_Pin_4, GPIO_Mode_In_PU_No_IT);
    
    GPIO_Init( GPIOB, GPIO_Pin_2, GPIO_Mode_Out_PP_Low_Fast);    
}

/**
 * @brief Timer Init :Timer2
 * @param[in] <none>
 * @return none
 */
void Timer_Init(void)
{
    CLK_PeripheralClockConfig(CLK_Peripheral_TIM2, ENABLE);  
    TIM2_Cmd(DISABLE);
    TIM2_DeInit();
    TIM2_TimeBaseInit(TIM2_Prescaler_16, TIM2_CounterMode_Up, 5000);
    TIM2_ARRPreloadConfig(ENABLE);
    TIM2_ClearFlag(TIM2_FLAG_Update);
    TIM2_ITConfig(TIM2_IT_Update, ENABLE);
    TIM2_SetCounter(0);
}

/**
 * @brief Usart Init :UART1 
 * @param[in] <none>
 * @return none
 */
void Usart_Init(void)
{
    CLK_PeripheralClockConfig(CLK_Peripheral_USART1, ENABLE); 
    USART_Init(USART1,UART_BOUNDRATE , USART_WordLength_8b, USART_StopBits_1,USART_Parity_No, USART_Mode_Tx);  
    USART_Cmd(USART1, ENABLE);
}

/**
 * @brief Status Init : work initial status : Judge work in carry mode or TRX mode(TX or RX normal mode)
 * @param[in] <none>
 * @return none
 */
void Status_Init(void)
{
    if(TRX_PIN_MODE)
    {
        Work_State = FUNCTION_RX;
        ucRFAPI_STATE = RFAPI_RX;  
        RF_RxMode();
        
        #ifdef  DEBUG_PRINT_STRING 
        printf("Initial RX!\r\n");
        #endif 
        
        //LED_ChangeFont(CHANNEL_TABLE[Channel_Index],LED_CHANNEL_MODE);
        LED_ChangeFont(Channel_Index,LED_CHANNEL_MODE);
        DISP_Status = LED_CHANNEL_MODE;
    }
    else
    {
        Work_State = FUNCTION_TX;
        ucRFAPI_STATE = RFAPI_TX;
        ucTXMode = MODE_TX_SINGLE;
        RF_TxMode();
        
        #ifdef  DEBUG_PRINT_STRING 
        printf("Initial TX!\r\n");
        #endif 
        
        LED_ChangeFont(ucTXMode,LED_FUNCTION_MODE);
        DISP_Status = LED_FUNCTION_MODE;
    }
   
    if(Key_Rd() == 0x01)
    {
        ucTest_Mode = TEST_CARRIER_MODE;     
    }
    else
    {
        ucTest_Mode = TEST_DEFAULT_MODE;      
    }
}

/**
 * @brief Sys init : Init periaral deviceIORF ...
 * @param[in] <none>
 * @return none
 */
void Sys_Init(void)
{
    IO_Init();
#ifdef  DEBUG_EN
    Usart_Init();
#endif
    Key_Init();
    LED_Init();
    RF_Init();
    Timer_Init();
    Status_Init();
}

/**
 * @brief Sys Start : Enable Timer,Enable ExtIntEnable Interrupt
 * @param[in] <none>
 * @return none
 */
void Sys_Start(void)
{
    TIM2_Cmd(ENABLE);
    EXTI_ClearITPendingBit(EXTI_IT_PortD);
}

void BIOS_Init(void)
{
    Oscillator_Init();
    __disable_interrupt();
    IO_Init();
    Usart_Init();
    Key_Init();
    LED_Init();
    Timer_Init();
   __enable_interrupt();    

    /*RF init*/
    RF_Init();
    
    /*RF Initial State : RX or TX */
    Status_Init();
  
    Sys_Start();
}

/******************************End of file************************************/