/*******************************************************************************
 * @note Copyright (C) 2020 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file RF.c
 * @brief
 *
 * @history - Vxx.xx ,Date :
*******************************************************************************/

#include "RF.H"
#include "RFAPI.H"
#include "stdio.h"
#include "App.h"
#include "Utility.h"
#include <math.h>

/*RF ַն˺ͷͶһ*/
const uint8_t TX_ADDRESS_DEF[5] = {0xCC,0xCC,0xCC,0xCC,0xCC};

unsigned short   Payload_Count = 0;
uint8_t fb=0;
int fc=0;

extern void RF_CalVco( uint8_t * ptr_Dem_cal1);
extern uint8_t Dem_cal1_data[];
extern uint8_t RF_cal1_data[];

void SPI_init(void)
{
    /*CE   output Low pulling push*/
    GPIO_Init( GPIOB, GPIO_Pin_1, GPIO_Mode_Out_PP_Low_Fast);                      
    
    /*CSN  output High pulling push*/
    GPIO_Init( GPIOB, GPIO_Pin_4, GPIO_Mode_Out_PP_High_Fast);                  
    
    /*SCK  output Low  pulling push*/ 
    GPIO_Init( GPIOB, GPIO_Pin_5, GPIO_Mode_Out_PP_Low_Fast);                   
    
    /*MOSI output High pulling push*/
    GPIO_Init( GPIOB, GPIO_Pin_6, GPIO_Mode_Out_PP_High_Fast);                  
    
    /*MISO input pull high*/
    GPIO_Init( GPIOB, GPIO_Pin_7, GPIO_Mode_In_PU_No_IT);                       
    
    /*IRQ  input pulling high without interrupt*/
    GPIO_Init( GPIOD, GPIO_Pin_0, GPIO_Mode_In_PU_No_IT);                       
}

 uint8_t SPI_RW( uint8_t R_REG)
{
    uint8_t i;
    for(i = 0; i < 8; i++)
    {
        SCK_LOW;
        
        if(R_REG & 0x80)
        {
            MOSI_HIGH;
        }
        else
        {
            MOSI_LOW;
        }
        
        R_REG = R_REG << 1;
        
        SCK_HIGH;
        
        if( MISO_STATUS )
        {
          R_REG = R_REG | 0x01;
        }
    }
    
    SCK_LOW;
    return R_REG;
}

void RF_WriteReg( uint8_t reg,  uint8_t wdata)
{
    CSN_LOW;
    SPI_RW(reg);
    SPI_RW(wdata);
    CSN_HIGH;
}

 uint8_t RF_ReadReg( uint8_t reg)
{
     uint8_t tmp;
    
    CSN_LOW;
    SPI_RW(reg);
    tmp = SPI_RW(0);
    CSN_HIGH;
    
    return tmp;
}

void RF_WriteBuf( uint8_t reg, uint8_t *pBuf, uint8_t length)
{
     uint8_t j;
    CSN_LOW;
    j = 0;
    SPI_RW(reg);
    for(j = 0;j < length; j++)
    {
        SPI_RW(pBuf[j]);
    }
    j = 0;
    CSN_HIGH;
}

void RF_ReadBuf( uint8_t reg, unsigned char *pBuf,  uint8_t length)
{
    uint8_t byte_ctr;

    CSN_LOW;                    		                               			
    SPI_RW(reg);       		                                                		
    for(byte_ctr=0;byte_ctr<length;byte_ctr++)
    	pBuf[byte_ctr] = SPI_RW(0);                                                 		
    CSN_HIGH;                                                                   		
}

void RF_TxMode(void)
{
    CE_LOW;
    
    /*RFóTXģʽ*/ 
    RF_WriteReg(W_REGISTER + CONFIG,  0X0E);							
    
    delay_10us(1);
}

void RF_RxMode(void)
{
    uint8_t     RF_cal3_temp[]    = {0x01,0x08,0xD4,0x02,0x64};
    uint8_t     RF_cal3_temp1[]    = {0x01,0x08,0xD4,0x02,0x66};  
    CE_LOW;
    
    //*RFóRXģʽ* 
    RF_WriteReg(W_REGISTER + CONFIG,  0X0F );							
    delay_ms(5);
    
    /*Set CE pin high */ 
    CE_HIGH;			
    /*keep ce high at least 150us*/
    delay_10us(15);
    
    RF_WriteBuf(W_REGISTER + RF_CAL3,   RF_cal3_temp, sizeof(RF_cal3_temp));
    delay_10us(1);
    RF_WriteBuf(W_REGISTER + RF_CAL3,   RF_cal3_temp1, sizeof(RF_cal3_temp1));       
    delay_ms(2);
}


uint8_t RF_GetStatus(void)
{
    /*ȡRF״̬ */
    return RF_ReadReg(STATUS)&0x70;
}


void RF_ClearStatus(void)
{
    /*RF״̬*/
    RF_WriteReg(W_REGISTER + STATUS,0x70);							
}

void RF_ClearFIFO(void)
{
    /*RF  TX FIFO*/
    RF_WriteReg(FLUSH_TX, 0);
    
    /*RF  RX FIFO*/
    RF_WriteReg(FLUSH_RX, 0);
}


void RF_SetPower( uint8_t * p,uint8_t power)
{    
    switch (power)
    {
    case RF18DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0xfe;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x07;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
                
    case RF17DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0xfe; 
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x01;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
        
    case RF16DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0xfa;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x01;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
        
    case RF15DBM:
        *(p+1) &= ~0xfe;
        *(p+1) |= 0xf8;
        *(p+2) &= ~0x07;
        *(p+2) |= 0x01;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5); 
        break;
       
    case RF13DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0x58;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x01;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break; 
        
    case RF12DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0x28;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x01;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;   
        
    case RF11DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0x10;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x01;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;   
        
    case RF10DBM:
         *(p+1) &= ~0xfe;
        *(p+1) |= 0xf8;
        *(p+2) &= ~0x07;
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);     
        break;
        
    case RF9DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0xd8;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
    
     case RF8DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0xc0;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;   
        
    case RF7DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0xb0;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
        
    case RF6DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0x98;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
        
    case RF5DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0x88;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
        
    case RF4DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0x78;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
            
    case RF2DBM:
        *(p+1) &= ~0xfe;
        *(p+1) |= 0x60;
        *(p+2) &= ~0x07;
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);     
        break;
        
    case RF1DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0x58;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break; 
        
    case RF0DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0x48;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
        
    case RFN1DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0x40;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
        
    case RFN6DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0x20;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
        
    case RFN15DBM :         
        *(p+1) &= ~0xfe;//8-15
        *(p+1) |= 0x08;
        *(p+2) &= ~0x07;//16-23
        *(p+2) |= 0x00;  
        RF_WriteBuf(W_REGISTER + RF_CAL1,   p, 5);    
        break;
   
     default:
        break;
     }
   
}

void RF_SetChannel(uint8_t bb,uint8_t cc )
{
    /*
        uint8_t RFSetup_temp = 0;
        Fb &= 0x3f;
        RFSetup_temp = RF_ReadReg(RF_SETUP)&0xc0;
        RFSetup_temp |= Fb;
    */
    RF_WriteReg(W_REGISTER+RF_SETUP,bb|DATA_RATE);        
    RF_WriteReg(W_REGISTER+RF_CH,cc);        
    //RF_CalVco(Dem_cal1_data);   
}

void RF_SetFreq_Datarate(double freq,uint8_t fre_band)
{
    #if DEBUG_ENABLE
    printf("freq_Set function :freq=%f,band=%d\r\n",freq,fre_band);
    #endif
  
    double tmp_val1 = 0;
    double fop_val = 0;
    double intpart,fractpart;
    
    switch (fre_band)
    {
        case B315MHz :  
            fop_val = freq *6 / 8 ;
            tmp_val1 = fop_val - 200;
            break;
          
        case B433MHz :  
            fop_val = freq *4 / 8 ;
            tmp_val1 = fop_val - 200;
            break;
            
        case B868MHz :  
        case B915MHz : 
            fop_val = freq *2 / 8 ;
            tmp_val1 = fop_val - 200;
            break;
        /*B433MH*/
        default:
            fop_val = freq *4 / 8 ;
            tmp_val1 = fop_val - 200;
            break;
    }

    fractpart = modf (tmp_val1 , &intpart);
    fb = (int)intpart;
    fc = (int)(fractpart * 200);
    
    #if DEBUG_ENABLE
    printf("freq_Set function :fb=%d,fc=%d\r\n",fb,fc);
    #endif
    
    RF_SetChannel(fb,fc);
  
}

void RF_Tx_TransmintData( uint8_t *ucTXPayload,  uint8_t length)
{
    uint8_t     RF_cal3_temp[]    = {0x01,0x08,0xD4,0x02,0x64};
    uint8_t     RF_cal3_temp1[]    = {0x01,0x08,0xD4,0x02,0x66};  
    
    /*rf ڿ״̬ŷ*/
    if(!RF_GetStatus())                                                                               
    {                                     		
        /*write data to txfifo  */
        RF_WriteBuf(W_TX_PAYLOAD, ucTXPayload, length);
        
        /*rf enter tx mode start send data*/
        CE_HIGH;
        /*keep ce high at least 150us*/
        delay_10us(15);
        
        /*лʱ*/
        RF_WriteBuf(W_REGISTER + RF_CAL3,   RF_cal3_temp, sizeof(RF_cal3_temp));
        RF_WriteBuf(W_REGISTER + RF_CAL3,   RF_cal3_temp1, sizeof(RF_cal3_temp1));
        CE_LOW;
    }
}

void  RF_Tx_CheckResult(uint8_t *ucAckPayload,  uint8_t length)
{
    switch(RF_GetStatus())
    {
        /*ͨͷ  ǿͷͳɹ*/ 	
        case    TX_DS_FLAG: 	
            /*ǿģʽۼack*/ 
            Payload_Count++;                                                                                             
            RF_ClearFIFO();
            RF_ClearStatus (); 
            break;
            
        /*ǿͷͳɹյpayload */ 
        case	RX_TX_FLAG:		                                                                
            RF_ReadBuf(R_RX_PAYLOAD,ucAckPayload, length);           
            Payload_Count++;  		                                         
            RF_ClearFIFO();
            RF_ClearStatus ();              
            break;
            
        /*ǿͷͳʱʧ*/ 
        case	MAX_RT_FLAG:		                                                        	                                          
            RF_ClearFIFO();
            RF_ClearStatus ();
            break;
        default:			
            break;			
    }
      
}

uint8_t RF_DumpRxData( uint8_t *ucPayload,  uint8_t length)
{ 
    if(RF_GetStatus()==0x40)
    {
      RF_ReadBuf(R_RX_PAYLOAD, ucPayload, length);  
      
      #if DEBUG_PRINT_RTX_BUFFER
      print_RTX_buffer(ucPayload, length);
      #endif
      return 1;
    }
    
    return 0;
}

void RF_CalVco( uint8_t * ptr_Dem_cal1)
{   
    uint8_t i=0,j=0,h=0;
   
    uint8_t Dem_cal2_data[]   = {0x0B,0xE7,0x00,0x01};  
    
    /*Dataout_Sel1*/
    uint8_t Dem_cal2_data1[]   = {0x0B,0xE7,0x00,0x03};  
    
    /*Vco_Calibration EN*/
    //uint8_t RF_cal3_data1[]    = {0x01,0x08,0xD4,0x02,0x76};  
    uint8_t RF_cal3_data1[]    = {0x01,0x08,0xD4,0x02,0x76};  
    
    /*Vco_Calibration_SPI_Triger*/
    //uint8_t RF_cal3_data2[]    = {0x01,0x18,0xD4,0x02,0x76}; 
    uint8_t RF_cal3_data2[]    = {0x01,0x18,0xD4,0x02,0x76};
    
    RF_RxMode();

    RF_WriteBuf(W_REGISTER + DEM_CAL2,   Dem_cal2_data1, sizeof(Dem_cal2_data1)); 
    RF_WriteBuf(W_REGISTER + RF_CAL3,   RF_cal3_data1, sizeof(RF_cal3_data1)); 
    RF_WriteBuf(W_REGISTER + RF_CAL3,   RF_cal3_data2, sizeof(RF_cal3_data2)); 
    delay_ms(5);
    i=RF_ReadReg(RPD);                                                                     
    j=RF_ReadReg(FIFO_STATUS);
    i >>= 2;
    i &= 0x30;
    j &= 0x0C;
    h = i|j;
    ptr_Dem_cal1[1] &= 0xC3;
    ptr_Dem_cal1[1] |= h;   
    
    RF_WriteBuf(W_REGISTER + DEM_CAL2,   Dem_cal2_data, sizeof(Dem_cal2_data)); 
    RF_WriteBuf(W_REGISTER + DEM_CAL1,   ptr_Dem_cal1, 0x05);
    CE_LOW;
}


/*********************²RFͨأ޸************************/

/*********************************433MHz***************************************/   

#if((DATA_RATE == DR_400K) && (BAND == B433MHz))
        uint8_t Dem_cal1_data[]   = {0x01,0x8e,0x48,0x4c,0x80};    
        uint8_t RF_cal1_data[]    = {0xC4,0xFF,0xFF,0xDF,0xDB};

#elif((DATA_RATE==DR_40K) && (BAND==B433MHz)) 

        uint8_t Dem_cal1_data[]   = {0x01,0x4D,0x48,0x34,0x8C};    
        uint8_t RF_cal1_data[]    = {0xC4,0xFF,0xFF,0x5F,0xD8};
        
#elif((DATA_RATE==DR_80K) && (BAND==B433MHz)) 
        
        uint8_t  Dem_cal1_data[]  = {0x01,0x8D,0x48,0x4C,0x8C};     
        uint8_t  RF_cal1_data[]   = {0xC4,0xFF,0xFF,0xDF,0xD8};
        
#elif((DATA_RATE==DR_200K) && (BAND==B433MHz)) 
        uint8_t  Dem_cal1_data[]  = {0x01,0x8C,0x48,0x4C,0x84};    
        uint8_t  RF_cal1_data[]   = {0xC4,0xFF,0xFF,0xDF,0xD9};     
        
/******************************************************************************/

/*********************************315MHz***************************************/          
        
#elif((DATA_RATE==DR_400K) && (BAND == B315MHz))        
       uint8_t Dem_cal1_data[]   = {0x01,0xea,0x48,0x74,0x80};     
       uint8_t RF_cal1_data[]    = {0xC5,0xFF,0xFF,0xDF,0xDB};
       
#elif((DATA_RATE==DR_40K) && (BAND==B315MHz))         
        uint8_t Dem_cal1_data[]   = {0x01,0x69,0x48,0x44,0x8C};     
        uint8_t RF_cal1_data[]    = {0xC5,0xFF,0xFF,0x5F,0xD8};    

#elif((DATA_RATE==DR_80K) && (BAND==B315MHz)) 
       uint8_t  Dem_cal1_data[]  = {0x01,0xe9,0x48,0x74,0x8C};    
       uint8_t  RF_cal1_data[]   = {0xC5,0xFF,0xFF,0xDF,0xD8};

#elif((DATA_RATE==DR_200K) && (BAND==B315MHz))      
       uint8_t  Dem_cal1_data[]  = {0x01,0xE8,0x48,0x74,0x84};     
       uint8_t  RF_cal1_data[]   = {0xC5,0xFF,0xFF,0xDF,0xD9};    
                
/******************************************************************************/
       
/*********************************868MHz***************************************/     
       
#elif((DATA_RATE==DR_400K) && (BAND == B868MHz))        
       uint8_t Dem_cal1_data[]   = {0x01,0x88,0x48,0x4c,0x94};    
       uint8_t RF_cal1_data[]    = {0xd0,0xFF,0xFF,0xDF,0xDB};   
       
#elif((DATA_RATE==DR_40K) && (BAND==B868MHz))         
        uint8_t Dem_cal1_data[]   = {0x01,0x09,0x80,0x19,0x5C};     
        uint8_t RF_cal1_data[]    = {0xd0,0xFF,0xFF,0x5F,0xD8}; 
        
#elif((DATA_RATE==DR_80K) && (BAND==B868MHz)) 
       uint8_t  Dem_cal1_data[]  = {0x01,0x09,0x00,0x21,0x5C};     
       uint8_t  RF_cal1_data[]   = {0xD0,0xFF,0xFF,0xDF,0xD8};

#elif((DATA_RATE==DR_200K) && (BAND==B868MHz))      
       uint8_t  Dem_cal1_data[]  = {0x01,0x89,0x48,0x4c,0x9c};     
       uint8_t  RF_cal1_data[]   = {0xd0,0xFF,0xFF,0xDF,0xD9};

/******************************************************************************/
       
/*********************************915MHz***************************************/ 
       
#elif((DATA_RATE==DR_400K) && (BAND == B915MHz))        
       uint8_t Dem_cal1_data[]   = {0x01,0x9c,0x48,0x54,0x84};     
       uint8_t RF_cal1_data[]    = {0xd0,0xFF,0xFF,0xDF,0xDB};     
       
#elif((DATA_RATE==DR_40K) && (BAND==B915MHz))         
        uint8_t Dem_cal1_data[]   = {0x01,0x1d,0x48,0x34,0x8C};       
        uint8_t RF_cal1_data[]    = {0xd0,0xFF,0xFF,0x5F,0xD8};    

#elif((DATA_RATE==DR_80K) && (BAND==B915MHz)) 
       uint8_t  Dem_cal1_data[]  = {0x01,0x1d,0x00,0x44,0x7C};     
       uint8_t  RF_cal1_data[]   = {0xD0,0xFF,0xFF,0xDF,0xD8};       
       
#elif((DATA_RATE==DR_200K) && (BAND==B915MHz))      
       uint8_t  Dem_cal1_data[]  = {0x01,0x9d,0x48,0x54,0x8c};     
       uint8_t  RF_cal1_data[]   = {0xD0,0xFF,0xFF,0xDF,0xD9};
       
#endif       
       
/******************************************************************************/      
void RF_Init(void)
{ 
    uint8_t BB_cal_data[]     = {0x3f,0xFC,0x1F,0x1F,0x04};         
    uint8_t RF_cal3_data[]    = {0x01,0x08,0xD4,0x02,0x46};
        
    /*
    ʹ̬ܶpayloadҪΪ  uint8_t Dem_cal2_data[]   = {0x0B,0xE7,0x00,0x00};
    */
    uint8_t Dem_cal2_data[]   = {0x0B,0xE7,0x00,0x01};          
    uint8_t  RF_cal2_data[]   = {0xC8,0x1E,0x68,0x39,0xF6};   
       
    uint8_t feature =0x00;
       
        
    SPI_init();
    delay_ms(10);  
    
    RF_WriteReg(RESET_CTL, 0x5A);	                                                        //Software Reset    			
    RF_WriteReg(RESET_CTL, 0XA5);
    delay_ms(1);  
        
    #if(DEBUG_RESET_REG_VAL)
       // RF_WriteReg(W_REGISTER + CONFIG,  0X00);
        print_reg_val();
    #endif        
        
        
    #if(CE_USE_SPI==1)
        feature |=0x20;
    #endif
        
    if(PAYLOAD_WIDTH >32)
        /*fifo 64 byte */ 
        feature |= 0x18;                                                                                                                                                       
                          
        /*CLEAR TXFIFO	*/ 
        RF_WriteReg(FLUSH_TX, 0);
        /*CLEAR  RXFIFO*/ 
        RF_WriteReg(FLUSH_RX, 0);
        /*CLEAR  STATUS*/ 
        RF_WriteReg(W_REGISTER + STATUS, 0x70);
        /*Enable Pipe0*/ 
        RF_WriteReg(W_REGISTER + EN_RXADDR, 0x01);
        /*address witdth is 5 bytes*/ 
        RF_WriteReg(W_REGISTER + SETUP_AW,  0x03);
        /*64bytes*/ 
        RF_WriteReg(W_REGISTER + RX_PW_P0,  PAYLOAD_WIDTH);
        /*Writes TX_Address to pan3020*/ 
        RF_WriteBuf(W_REGISTER + TX_ADDR,   ( uint8_t*)TX_ADDRESS_DEF, sizeof(TX_ADDRESS_DEF));
        /*RX_Addr0 same as TX_Adr for Auto.Ack*/ 
        RF_WriteBuf(W_REGISTER + RX_ADDR_P0,( uint8_t*)TX_ADDRESS_DEF, sizeof(TX_ADDRESS_DEF));		 
    
        RF_WriteBuf(W_REGISTER + BB_CAL,    BB_cal_data,  sizeof(BB_cal_data));
    
        RF_WriteBuf(W_REGISTER + DEM_CAL1,   Dem_cal1_data, sizeof(Dem_cal1_data));
        RF_WriteBuf(W_REGISTER + DEM_CAL2,   Dem_cal2_data, sizeof(Dem_cal2_data)); 
    
        RF_WriteBuf(W_REGISTER + RF_CAL1,   RF_cal1_data, sizeof(RF_cal1_data));   
        RF_WriteBuf(W_REGISTER + RF_CAL2,   RF_cal2_data, sizeof(RF_cal2_data));
        RF_WriteBuf(W_REGISTER + RF_CAL3,   RF_cal3_data, sizeof(RF_cal3_data));
	    
    #if(TRANSMIT_TYPE == TRANS_ENHANCE_MODE)      
        /*3 retrans... */  
        RF_WriteReg(W_REGISTER + SETUP_RETR,0x03);
        /*Enable Auto.Ack:Pipe0  */ 
        RF_WriteReg(W_REGISTER + EN_AA,0x01);								
        RF_WriteReg(ACTIVATE, 0x73);
	
        /*ENDYNPD */ 
        #if(1== EN_DYNPLOAD)        	                                        
        feature |= 0x04;                                                                                               
        RF_WriteReg(W_REGISTER +DYNPD, 0x01);     
        #endif  
   
        /*en ack+payload*/
        #if(1==EN_ACK_PAYLOAD)                                                                             
        feature |= 0x02;
        #endif  
        
    #elif(TRANSMIT_TYPE == TRANS_BURST_MODE) 
        /*Disable retrans...*/ 
        RF_WriteReg(W_REGISTER + SETUP_RETR,0x00);
        /*Disable AutoAck */ 
        RF_WriteReg(W_REGISTER + EN_AA,     0x00);							
    #endif
        
    RF_WriteReg(W_REGISTER +FEATURE, feature); 
    
    /*set datarate */

    //RF_WriteReg(W_REGISTER + RF_SETUP,  DATA_RATE|fb);                                              
    //RF_WriteReg(W_REGISTER + RF_CH,  fc);

    /* use RF_SetFreq_Datarate API to replace RF_SetChannel */
    /* set fre & datarate */ 
    //RF_SetChannel(fb,fc);
    RF_SetFreq_Datarate(FREQ_SETTING,BAND);
    RF_CalVco(Dem_cal1_data); 
    
    #if DEBUG_ENABLE
    printf("RF init (2):fb=%d,fc=%d\r\n",fb,fc);
    #endif
    
    /*set power*/ 
    RF_SetPower(RF_cal1_data,RF_POWER);								
        
    #if(DEBUG_ENABLE)
    uint8_t i=0;
    for(i=0;i<5;i++)
    {    
        printf("0x%02x",Dem_cal1_data[i]);
        printf("\n");             
    }
    #endif
}

void RF_Carrier(void)
{
  
    uint8_t  BB_cal_data[]    = {0x09,0x04,0x07,0x1F,0x05};
    uint8_t Dem_cal1_data[]   = {0xE1,0x8e,0x48,0x4c,0x80};
    uint8_t Dem_cal2_data[]   = {0x0B,0xE7,0x00,0x05};
    uint8_t RF_cal1_data[]    = {0xC4,0xFF,0xFF,0xDF,0xDB};
    uint8_t RF_cal2_data[]    = {0xC8,0x1E,0x68,0x39,0xF6};
    uint8_t RF_cal3_data[]    = {0x01,0x08,0xD4,0x02,0x66};
        
    uint8_t   RF_cal3_temp[]    = {0x01,0x08,0xD4,0x02,0x64};
    uint8_t   RF_cal3_temp1[]    = {0x01,0x08,0xD4,0x02,0x66};
    
    SPI_init(); 
    CE_HIGH;
    delay_10us(500);									
    RF_WriteReg(W_REGISTER + CONFIG, 0x0E);
    RF_WriteReg(W_REGISTER + RF_SETUP,  0xd2); 

    #if DEBUG_ENABLE
    printf("Channel_Index = %d\r\n",Channel_Index);
    #endif
    
    //RF_SetChannel(fb,CHANNEL_TABLE[Channel_Index]);
    RF_SetFreq_Datarate(FREQ_SETTING,BAND);
    RF_CalVco(Dem_cal1_data);  
    
    RF_WriteBuf(W_REGISTER + BB_CAL,  BB_cal_data,  sizeof(BB_cal_data));
    RF_WriteBuf(W_REGISTER + RF_CAL2,  RF_cal2_data,  sizeof(RF_cal2_data));
    RF_WriteBuf(W_REGISTER + RF_CAL3,  RF_cal3_data,  sizeof(RF_cal3_data));  
    RF_WriteBuf(W_REGISTER + DEM_CAL2, Dem_cal2_data, sizeof(Dem_cal2_data));
    delay_10us(500);	
    RF_WriteBuf(W_REGISTER + DEM_CAL1, Dem_cal1_data, sizeof(Dem_cal1_data));
    delay_10us(500);	
    RF_SetPower(RF_cal1_data,RF_POWER);
    CE_LOW;
    RF_WriteBuf(W_REGISTER + RF_CAL3,   RF_cal3_temp, sizeof(RF_cal3_temp));
    RF_WriteBuf(W_REGISTER + RF_CAL3,   RF_cal3_temp1, sizeof(RF_cal3_temp1));  
}

void print_reg_val(void){
    int i;
    uint8_t red_reg_buf[5];
    
    printf("the value of reg as following :\r\n");
    
    for(i= 0;i<31;i++)
    {
      if((i==RX_ADDR_P0)||(i==RX_ADDR_P1)||(i==TX_ADDR)||(i==RF_CAL3)||(i==DEM_CAL1)||(i==RF_CAL2)||(i==DEM_CAL2)||(i==RF_CAL1)||(i==BB_CAL))
      {
        RF_ReadBuf(i,red_reg_buf,5);
        printf("Reg_0x%x value is ",i);
        for(int j=0;j<5;j++)
        {
          printf("0x%x ",red_reg_buf[j]);
        }
        printf("\r\n");
      }else{
        printf("Reg_0x%x value is 0x%x\r\n",i,RF_ReadReg(i));
      }
    }
    printf("end of reading reg \r\n");
    
}

void print_RTX_buffer(uint8_t *ucPayload,  uint8_t length)
{
    if( Work_State == FUNCTION_RX)
    {
      printf("RX buffer(len = %d) as following:\r\n",length);
    }
   
    if( Work_State == FUNCTION_TX)
    {
      printf("TX buffer(len = %d) as following:\r\n",length);
    }
    
    for(int i =0;i<length;i++)
    {
      printf("0x%x ",ucPayload[i]);
    }
    
    printf("\r\n");
}

/***************************************end of file ************************************/