/*******************************************************************************
 * @note Copyright (C) 2020 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file APP.c
 * @brief
 *
 * @history - Vxx.xx ,Date :
*******************************************************************************/

#include "stm8l15x.h"
#include "App.h"
#include "appsub.h"
#include "LED.h"
#include "Key.h"
#include "stdio.h"

unsigned char DISP_Status;
unsigned long int ulState_Timer = 0;
bool DATA_READY = FALSE, TIME_8MS = FALSE;
bool  RX_READY = FALSE,DATA_READY_ADC = FALSE;
bool TX_TRIGGER = FALSE,TX_RQ = FALSE,TX_TIME=FALSE;
bool  LED_flag =TRUE;
unsigned char ucLED_FlashCnt = 0;
unsigned short TRX_Cnt = 0;
unsigned char ucTXMode = MODE_TX_SINGLE;

void  APP_StateMachine(void)
{
    if(Work_State == FUNCTION_RX)
    {
        APP_RX_Normal();    
    }
    else if(Work_State == FUNCTION_TX)
    {
        APP_TX_Normal();    
    }
}

/**
 * @brief APP RX Event handler
 * @param[in] <none>
 * @return none
 */
void APP_RX_Event(void)
{
    /*RF RX data prepare*/
    if(RX_READY)                                                                  
    {
        #ifdef  DEBUG_EN
        printf("RX_Event[Rx_cnt=%d(0X%x)]\n",TRX_Cnt,TRX_Cnt);    
        #endif
        
        RX_READY = FALSE;
        
        /*RX Count add 1*/
        TRX_Cnt++;      
        
        /*if LED has been in count mode*/
        if(DISP_Status == LED_CNT_MODE)                                           
        {
            LED_ChangeFont(TRX_Cnt,LED_CNT_MODE);
            DISP_Status = LED_CNT_MODE;
        }
    }
  
    /*if Key Event*/
    if(DATA_READY)                                                                
    {
        //printf("key_rd:%x\n",ucKey_RD);    
        DATA_READY = FALSE;
        
        /*if press Key1 button down*/
        if(ucKey_RD == KEY1)                                                        
        {
            /*if LED has been in count mode*/
            if(DISP_Status == LED_CNT_MODE)                                       
            {
                #ifdef  DEBUG_EN
                printf("Clear cnt\n");    
                #endif
                
              /*clear rx count*/
              TRX_Cnt = 0; 
            }
            
            /*set LED in count mode*/
            LED_ChangeFont(TRX_Cnt,LED_CNT_MODE);                                 
            DISP_Status = LED_CNT_MODE;
        }
        /*if press Key2 button down*/
        else if(ucKey_RD == KEY2)                                                 
        {
            #ifdef  DEBUG_EN
            printf("key 2\n");    
            #endif
        }
        /*if press Key3 button down*/
        else if(ucKey_RD == KEY3)                                                 
        {
            /*if LED in Channel Mode*/
            if(DISP_Status == LED_CHANNEL_MODE)                                   
            {
                /*Set RF work in Next Channel*/
                RFAPI_ChannelNext();
                
                /*Set RF work in RX mode*/
                RF_RxMode();                                                      
            }
   
            LED_ChangeFont(Channel_Index,LED_CHANNEL_MODE);  
            
            /*set LED in Channel mode*/
            DISP_Status = LED_CHANNEL_MODE;                                       

            #ifdef  DEBUG_EN  
            printf("Hop channel(RX):%d\n",Channel_Index);  
            #endif

            #if DEBUG_ENABLE      
            printf("APP_RX_Event --fb=%d,fc=%d \r\n",fb,fc);
            #endif
            RF_SetChannel(fb,fc);
        }
    }
}

void APP_RX_Normal(void)
{
    /*Event handler*/
    APP_RX_Event();
    
    /*scan key status*/
    Key_Scan();                                  
    
    /*LED handler*/
    LED_Display();                                
}

/**
 * @brief Switch TX MODE from:Function A,B and C
        A:  single TX
        B:  1000packet TX
        C:  continues TX
 * @param[in] <none>
 * @return none
 */
void APP_TXMODE_Swtich(void)
{
    if(ucTXMode == MODE_TX_SINGLE)
    {
        /*Switch into B:1000 packets*/
        ucTXMode = MODE_TX_1000PACK;                                            
        TRX_Cnt = 1000;
    }
    else if(ucTXMode == MODE_TX_1000PACK)
    {
        /*Switch into C:Continous Tx*/
        ucTXMode = MODE_TX_CONTINUE;                                            
        TRX_Cnt = 0;
    }
    else
    {
        /*Switch into A:single Tx*/
        ucTXMode = MODE_TX_SINGLE;                                              
        TRX_Cnt = 0;
    }
}

/**
 * @brief TX Event handler
 * @param[in] <none>
 * @return none
 */
void  APP_TX_Event(void)
{
    /*Key Event occur*/
    if(DATA_READY)                                                                
    {
        DATA_READY = FALSE;
        
        /*if press Key1 button down*/
        if(ucKey_RD == KEY1)                                                        
        {
            TX_TRIGGER = FALSE;
            /*if LED in Function mode*/
            if(DISP_Status == LED_FUNCTION_MODE)                                    
            {
                /*function switch*/
                APP_TXMODE_Swtich();                                                
                
                #ifdef  DEBUG_EN
                printf("function switch:%x\n",ucTXMode);    
                #endif
            }
            else
            {
                if(ucTXMode == MODE_TX_SINGLE)
                {
                    TRX_Cnt = 0;
                }
                else if(ucTXMode == MODE_TX_1000PACK)
                {
                    TRX_Cnt = 1000;
                }
                else
                {
                    TRX_Cnt = 0;
                }          
            }
            
            /*set LED in function switch and clear tx count*/
            DISP_Status = LED_FUNCTION_MODE;                                       
            LED_ChangeFont(ucTXMode,LED_FUNCTION_MODE);
        }
        /*if press Key2 button down*/
        else if(ucKey_RD == KEY2)                                                   
        {
            /*start or stop tx  */
            if(TX_TRIGGER)                                                            
            {
                TX_TRIGGER = FALSE;           
            }
            else
            {
                TX_TRIGGER = TRUE;          
            }

            #ifdef  DEBUG_EN
            printf("start trigger\n");    
            #endif
        }
        /*if press Key3 button down*/
        else if(ucKey_RD == KEY3)                                                   
        {
            //#if(1==EN_ACK_PAYLOAD)
            //#if(TRANSMIT_TYPE == TRANS_ENHANCE_MODE)  
        #if 0
            if(LED_flag) 
            {
                LED_flag =FALSE; 
                LED2_ON;
            }
            else
            {
                LED_flag =TRUE; 
                LED2_OFF;
            }
             
            DISP_Status = LED_OTHER_MODE;               
            TRX_Cnt=  Payload_Count;
            Payload_Count=0;
            LED_ChangeFont(TRX_Cnt,LED_CNT_MODE);
            DISP_Status = LED_CNT_MODE; 
        #else  
            /*if LED in Channel mode*/
            if(DISP_Status == LED_CHANNEL_MODE)                                     
            {
                /*RF hop to hext channel*/
                RFAPI_ChannelNext();  
                
                #ifdef  DEBUG_EN
                printf("Hop channel(TX):%d\n",Channel_Index);
                #endif
            }
            TX_TRIGGER = FALSE;
            
            /*set LED in channel mode*/
            DISP_Status = LED_CHANNEL_MODE;                                         
            LED_ChangeFont(Channel_Index,LED_CHANNEL_MODE);
        #endif
        
            #if DEBUG_ENABLE      
            printf("APP_TX_Event --fb=%d,fc=%d \r\n",fb,fc);
            #endif
            
            RF_SetChannel(fb,fc);
        }
    }
    
    /*if triggered and 8msEvent and TX idle*/
    if((TX_TRIGGER)&&(TX_TIME)&&(ucRFAPI_STATE == RFAPI_TX))                          
    {
        TX_TIME = FALSE;
        
        /*enable Tx*/
        TX_RQ = TRUE;                                                             
      
        /*if in single mode*/
        if(ucTXMode == MODE_TX_SINGLE)                                            
        {
            TRX_Cnt++;                                    
            TX_TRIGGER = FALSE;
            
            #ifdef  DEBUG_EN
            printf("trigger stop\n");    
            #endif
        }
        /*if in continues mode*/
        else if(ucTXMode == MODE_TX_CONTINUE)                                     
        {
            TRX_Cnt++;
            
            /*if LED overflow*/
            if(TRX_Cnt >= 9999)                                                   
            {
                TRX_Cnt = 0;
            }
        }
        /*if in single mode*/
        else                                                                      
        {
            if(TRX_Cnt>0)                               
            {
                TRX_Cnt--;
            }
            /*if tx over*/ 
            else                                                                  
            {
                TRX_Cnt = 1000;
                TX_RQ = FALSE;   
                
                /*stop tx*/
                TX_TRIGGER = FALSE;                                               
                #ifdef  DEBUG_EN
                printf("trigger stop \n");    
                #endif
            }
        }
        LED_ChangeFont(TRX_Cnt,LED_CNT_MODE);
        DISP_Status = LED_CNT_MODE;
    }
}

void APP_TX_Normal(void)
{
      APP_TX_Event();
      LED_Display();
      Key_Scan();
}

/******************************End of file************************************/