/*******************************************************************************
 * @note Copyright (C) 2020 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file RF.h
 * @brief
 *
 * @history - Vxx.xx ,Date :
*******************************************************************************/

#ifndef   _RF_PAN3020_H_
#define   _RF_PAN3020_H_

///////////////////////////////////////////////////////////////////////////////
//                  ûӦã²ֿҪ޸                       //
///////////////////////////////////////////////////////////////////////////////
/******************** Control I/O *****************************/
#include "stm8l15x.h"
#include "stm8l15x_gpio.h"

#define         IRQ_STATUS       GPIOD->IDR &  (uint8_t)GPIO_Pin_0
#define         CE_PIN_HIGH      GPIOB->ODR |= GPIO_Pin_1
#define         CE_PIN_LOW       GPIOB->ODR &= (~GPIO_Pin_1)

#define         CSN_HIGH         GPIOB->ODR |= GPIO_Pin_4
#define         CSN_LOW          GPIOB->ODR &= (~GPIO_Pin_4)
#define         SCK_HIGH         GPIOB->ODR |= GPIO_Pin_5
#define         SCK_LOW          GPIOB->ODR &= (~GPIO_Pin_5)
#define         MOSI_HIGH        GPIOB->ODR |= GPIO_Pin_6;
#define         MOSI_LOW         GPIOB->ODR &= (~GPIO_Pin_6)
#define         MISO_STATUS      GPIO_ReadInputDataBit(GPIOB,GPIO_Pin_7)


/******************** Ϊ֣޸********************/
#define         TRANS_ENHANCE_MODE    1                                         /*ǿ*/
#define         TRANS_BURST_MODE      2                                         /*ͨ*/



/******************** RF COMMAND REGISTER  ********************/
#define		R_REGISTER			0x00                            /*read State Register*/
#define		W_REGISTER			0x20                            /*write State Register*/
#define		R_RX_PAYLOAD		        0x61                            /*read RX payload*/
#define		W_TX_PAYLOAD		        0xA0                            /*write TX buffer */
#define		FLUSH_TX			0xE1                            /*Flush TX FIFO*/
#define		FLUSH_RX			0xE2                            /*Flush RX FIFO*/
#define		REUSE_TX_PL			0xE3                            /*Reuse TX Payload*/
#define		ACTIVATE			0x50                            /*ACTIVATE functons :R_RX_PL_WIDW_TX_PAYLOAD_NOACK? W_ACK_PAYLOAD*/
#define		DEACTIVATE			0x50                            /*DE_ACTIVATE functons :R_RX_PL_WIDW_TX_PAYLOAD_NOACK? W_ACK_PAYLOAD*/
#define		R_RX_PL_WID			0x60                            /*Read width of RX data*/ 
#define		W_ACK_PAYLOAD		        0xA8                            /*Data with ACK under RX mode*/
#define		W_TX_PAYLOAD_NOACK	        0xB0                            /*TX Payload no ACK Request*/
#define		CE_FSPI_LOW	                0xFC                            /*make CE inner logic 1 by spi order*/ 
#define		CE_FSPI_HIGH	                0xFD                            /*make CE inner logic 0 by spi order*/ 
#define		RESET_CTL	                0x53                            /*RESET*/ 
#define		REV				0xFF                            /*Chip Version*/ 
             
/****************** RF CONTROL & CONFIGURATION  REGISTER*******************/
#define		CONFIG				0x00
#define		EN_AA				0x01
#define		EN_RXADDR			0x02
#define		SETUP_AW			0x03
#define		SETUP_RETR			0x04
#define		RF_CH				0x05
#define		RF_SETUP			0x06
#define		STATUS				0x07
#define		OBSERVE_TX			0x08
#define		RPD			        0x09
#define		RX_ADDR_P0			0x0A
#define		RX_ADDR_P1			0x0B
#define		RX_ADDR_P2			0x0C
#define		RX_ADDR_P3			0x0D
#define		RX_ADDR_P4			0x0E
#define		RX_ADDR_P5			0x0F
#define		TX_ADDR		                0x10
#define		RX_PW_P0			0x11
#define		RX_PW_P1			0x12
#define		RX_PW_P2			0x13
#define		RX_PW_P3			0x14
#define		RX_PW_P4			0x15
#define		RX_PW_P5			0x16
#define		FIFO_STATUS			0x17
#define		RF_CAL3  			0x18
#define		DEM_CAL1			0x19
#define		RF_CAL2 			0x1A
#define		DEM_CAL2 			0x1B
#define		DYNPD				0x1C
#define		FEATURE			        0x1D	
#define		RF_CAL1			        0x1E
#define		BB_CAL				0x1F


/////////////////////////////////////////////////////////////////////////////////////
/*************************CONTROL CMD****************************************/
#define         DR_400K                         0XC0				//ͨ 400Kbps
#define         DR_200K                         0X80				//ͨ 200Kbps
#define         DR_80K                          0X40				//ͨ 80Kbps
#define         DR_40K                          0X00				//ͨ 40Kbps

/*************************CONTROL CMD****************************************/
#define         B315MHz                         1                               //ͨƵ 315
#define         B433MHz                         2                               //ͨƵ 433
#define         B868MHz                         3                               //ͨƵ 868
#define         B915MHz                         4                               //ͨƵ 915


/**************************************************************************/

#define         RX_DR_FLAG                      0x40
#define         TX_DS_FLAG                      0x20
#define         MAX_RT_FLAG                     0x10
#define         RX_TX_FLAG                      0x60

#define         RF18DBM                        (1)
#define         RF17DBM                        (2)
#define         RF16DBM                        (3)
#define         RF15DBM                        (4)
#define         RF13DBM                        (5)
#define         RF12DBM                        (6)
#define         RF11DBM                        (7)
#define         RF10DBM                        (8)
#define         RF9DBM                         (9)
#define         RF8DBM                         (10)
#define         RF7DBM                         (11)
#define         RF6DBM                         (12)
#define         RF5DBM                         (13)
#define         RF4DBM                         (14)
#define         RF2DBM                         (15)
#define         RF1DBM                         (16)
#define         RF0DBM                         (17)
#define         RFN1DBM                        (18)
#define         RFN6DBM                        (19)
#define         RFN15DBM                       (20)


/*----------------------------Ƶ㷶Χ(λMHZ)-----------------------------------*/
#define FREQ_270                  (270)
#define FREQ_360                  (360)
#define FREQ_400                  (400)
#define FREQ_550                  (550)
#define FREQ_800                  (800)
#define FREQ_1100                 (1100)

///////////////////////////////////////////////////////////////////////////////
//                  ûӦã²ֿҪ޸                       //
///////////////////////////////////////////////////////////////////////////////

extern          unsigned short  Payload_Count;
extern          uint8_t fb;
extern          int fc;

/******************* Function declare *******************/
/**
 * @brief SPI init : init spi pin and IRQ  CE input/out mode
 * @param[in] <none>
 * @return none
 */
void    SPI_init(void);
          
/**
 * @brief SPI Write/Read Data : SPIдһBYTEͬʱһBYTE
 * @param[in] <R_REG>
 * @return uint8_t
 */
uint8_t SPI_RW( uint8_t	 R_REG);

/**
 * @brief Write Data(1 Byte Address ,1 byte data)
 * @param[in] 
 * @return none
 */
void RF_WriteReg( uint8_t reg,  uint8_t wdata);

/**
 * @brief Read Data(1 Byte Address ,1 byte data return)
 * @param[in] <reg>
 * @return uint8_t
 */
uint8_t RF_ReadReg( uint8_t reg);

/**
 * @brief Write Buffer
 * @param[in] uint8_t reg, written buffer register
              uint8_t *pBuf, : written buffer
              uint8_t length:written buffer length
 * @return none
 */
void 	RF_WriteBuf( uint8_t reg,  uint8_t *pBuf,  uint8_t length);

/**
 * @brief Read Buffer
 * @param[in] uint8_t reg, read buffer register
              uint8_t *pBuf, : read buffer
              uint8_t length:read buffer length
 * @return none
 */
void 	RF_ReadBuf( uint8_t reg,  uint8_t *pBuf,  uint8_t length);

/**
 * @brief Set RF into TX mode
 * @param[in] <none>
 * @return none
 */
void 	RF_TxMode(void);

/**
 * @brief Set RF into RX mode for reciving data
 * @param[in] <none>
 * @return none
 */
void    RF_RxMode(void);

/**
 * @brief read RF IRQ status,
 * @param[in] <none>
 * @return 3bits return
 */
uint8_t RF_GetStatus(void);

/**
 * @brief clear RF IRQ,
 * @param[in] <none>
 * @return none
 */
void 	RF_ClearStatus(void);

/**
 * @brief clear RF TX/RX FIFO
 * @param[in] <none>
 * @return none
 */
void    RF_ClearFIFO(void);
    
/**
 * @brief set power 
 * @param[in] in: RF_cal1_data
              in: power   ndbm ,define by rf.h
 * @return none
 */
void     RF_SetPower( uint8_t * p,uint8_t power);

/**
 * @brief set freq 
 * @param[in] in Fb[5:0], FC[8:1]
 *note :
 *      315   fre = 1/6*8000000*(200+fb+fc/400)hz
 *      433  fre = 1/4*8000000*(200+fb+fc/400)hz=400Mhz+2fbMhz+50fckHz
 *      868 915 feq = 1/2*8000000*(200+fb+fc/400)hz=800Mhz+4fbMhz+100kHz
 *      for example fre= 434.1khz ,Fb=0x11  Fc=0x01.  default fc[0]=0,only set fc[8:1](reg5) .
 * @return none 
 */
void    RF_SetChannel(uint8_t Fb,uint8_t Fc );

/**
 * @brief set freq API interface 
 * @param[in] double freq : setting freq;
              freq_band : Select from B315,B433,B868,B915
 *note :
 *      315   fre = 1/6*8000000*(200+fb+fc/400)hz
 *      433  fre = 1/4*8000000*(200+fb+fc/400)hz=400Mhz+2fbMhz+50fckHz
 *      868 915 feq = 1/2*8000000*(200+fb+fc/400)hz=800Mhz+4fbMhz+100kHz
 *      for example fre= 434.1khz ,Fb=0x11  Fc=0x01.  default fc[0]=0,only set fc[8:1](reg5) .
 * @return none 
 */
void RF_SetFreq_Datarate(double freq,uint8_t fre_band);
/**
 * @brief send Tx data 
 * @param[in] ucTXPayload: Tx data 
              length: lenght of Tx data
 * @return none
 */
void    RF_Tx_TransmintData( uint8_t *ucTXPayload,  uint8_t length);

/**
 * @brief ֻǿģʽ£ʹackpayloadЧ
 * @param[in] ucTXPayload: Tx data 
              length: lenght of Tx data
 * @return none
 */
void    RF_Tx_CheckResult(uint8_t *ucAckPayload,  uint8_t length);
           
/**
 * @brief յݣ
 * @param[in] ucTXPayload: 洢ȡݵBuffer
              length: ȡݳ
 * @return 
 *      1. 0: ûнյ
 *      2. 1: ȡյݳɹ
 *      note: Only use in Rx Mode
 *      length ͨ PAYLOAD_WIDTH
 */
uint8_t RF_DumpRxData( uint8_t *ucPayload,  uint8_t length);

/**
 * @brief Vco_Calibration
 * @param[in] uint8_t * ptr_Dem_cal1
 * @return none
 */
void RF_CalVco( uint8_t * ptr_Dem_cal1);

/**
 * @brief RF init
 * @param[in] none
 * @return none
 */
void    RF_Init(void);

/**
 * @brief زģʽ
 * @param[in] none
 * @return none
 */
void    RF_Carrier(void);

/**
 * @brief print register's value
 * @param[in] none
 * @return none
 */
void    print_reg_val(void);

/**
 * @brief print Rx or Tx data 
 * @param[in] 
        ucPayload:Rx or Tx data
        length: data length
 * @re
*/
void    print_RTX_buffer(uint8_t *ucPayload,  uint8_t length);


/****************** Parameter Configuration **********************/

/*SPI Sel:      1:Soft CE  | 0:Hardware CE*/
#define         CE_USE_SPI                     1                        

/*Data Rate : DR_40K | DR_80K | DR_200K | DR_400K*/
#define         DATA_RATE                      DR_40K                   

/*Payload length 64bytes*/
#define         PAYLOAD_WIDTH                  16		        

/*select  TRANS_BURST_MODE  or   TRANS_ENHANCE_MODE*/
#define         TRANSMIT_TYPE                  TRANS_BURST_MODE 	

 /*
  RF18DBM    RF17DBM    RF16DBM    RF15DBM    RF13DBM    RF12DBM    RF11DBM    RF10DBM    RF9DBM    RF8DBM
  RF7DBM     RF6DBM     RF5DBM     RF4DBM     RF2DBM     RF1DBM     RF0DBM     RFN1DBM    RFN6DBM   RFN15DBM
*/
#define         RF_POWER                       RF18DBM                   

/*Ƶζ B315MHz, B433MHz, B868MHz ,B915MHz*/
#define         BAND                           B433MHz  
/*
FREQ            FB              FC
436.16  :       0X12(18)         0X20(32)


*/
#define         FREQ_SETTING                    (433)

#if(TRANSMIT_TYPE == TRANS_ENHANCE_MODE)  
    #define         EN_DYNPLOAD                    0
    #define         EN_ACK_PAYLOAD                 0                    /*ack_payload must < =32 byte*/ 
#endif


//***************************************************************//  
#if(CE_USE_SPI == 0)
    #define   CE_LOW            CE_PIN_LOW
    #define   CE_HIGH           CE_PIN_HIGH
#else
    #define   CE_LOW            RF_WriteReg(CE_FSPI_LOW, 0)
    #define   CE_HIGH           RF_WriteReg(CE_FSPI_HIGH, 0)
#endif

#endif


/******************************End of file************************************/