/*******************************************************************************
 * @note Copyright (C) 2020 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file RFAPI.h
 * @brief
 *
 * @history - Vxx.xx ,Date :
*******************************************************************************/

#ifndef _RF_API_H_
#define _RF_API_H_

#include "RF.h"

typedef union 
{
    uint8_t ucPayload[PAYLOAD_WIDTH];
}RF_PAYLOAD;

enum RFAPI_WorkMode
{
    TEST_DEFAULT_MODE = 0,
    TEST_CARRIER_MODE ,
    TEST_TX_MODE,
    TEST_NoHOP_MODE
};

enum  RFAPI_CommuSate
{
    RFAPI_RX,
    RFAPI_TX,
    RFAPI_HALT  
};

extern    uint8_t const CHANNEL_TABLE[];
extern    bool  bRFAPI_IRQ;
extern    RF_PAYLOAD RF_Payload;
extern    uint8_t Channel_Index;
extern    const uint8_t TX_ADDRESS_DEF[]; 
extern    uint8_t const CHANNEL_TABLE[];
extern    enum  RFAPI_CommuSate  ucRFAPI_STATE;

/**
 * @brief In RX status ,Judge data has been received and read them
 * @param[in] <none>
 * @return none
 */
void RFAPI_RXState(bool RX_Continue);

/**
 * @brief in IRFAPI_TxState , write Data into RF when TX enabled
 * @param[in] <none>
 * @return none
 */
void RFAPI_TXState(void);

/**
 * @brief TX/RX Work StateMachine
 * @param[in] <none>
 * @return none
 */
void RFAPI_StateMachine(void);

/**
 * @brief prepare for tx buffer
 * @param[in] <none>
 * @return none
 */
void RFAPI_PacketData(void);

/**
 * @brief Hop to next channel
 * @param[in] <none>
 * @return none
 */
void RFAPI_ChannelNext(void);

/**
 * @brief Set RF into TestMode
 * @param[in] <none>
 * @return none
 */
void RFAPI_TestMode(void);
#endif

/******************************End of file************************************/