/*******************************************************************************
 * @note Copyright (C) 2020 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file LED.c
 * @brief
 *
 * @history - Vxx.xx ,Date :
*******************************************************************************/
#include "stm8l15x.h"
#include "LED.h"
#include "App.h"
#include "stdio.h"
#include "Utility.h"

static uint8_t ucLED_DIS[4] = {EIGHT,EIGHT,EIGHT,EIGHT};
bool bLED_Enable=TRUE;
/******************************************************************************/
//            LED_TAB
//                LED character Table
/******************************************************************************/
const uint8_t LED_TAB[] = 
{
    0xC0,   //'0'  
    0xF9,   //'1' 
    0xA4,   //'2' 
    0xB0,   //'3' 
    0x99,   //'4' 
    0x92,   //'5' 
    0x82,   //'6' 
    0xF8,   //'7' 
    0x80,   //'8' 
    0x90,   //'9' 
    0xBF,   //'-' 
    0xFF,   //' ' 
    0x86,   //'E' 
    0x88,   //'R' 
    0x46,   //'c.' 
    0x00,   //'8.' 
    0x8E,   //'F'
    0x88,   //'A'
    0x83,   //'b'
    0xc6,   //'C'
    0x0B,    //'h'
    0x09    //'H'
};

void LED_Init(void)
{
    unsigned char i;
    for(i=0;i<sizeof(ucLED_DIS);i++)
    {
        ucLED_DIS[i] = 8;
    }
    
    GPIO_Init(GPIOC, GPIO_Pin_4, GPIO_Mode_Out_PP_High_Fast);  
    GPIO_Init(GPIOC, GPIO_Pin_5, GPIO_Mode_Out_PP_High_Fast);  
    GPIO_Init(GPIOC, GPIO_Pin_6, GPIO_Mode_Out_PP_High_Fast);
    GPIO_Init(GPIOD, GPIO_Pin_4, GPIO_Mode_Out_PP_Low_Fast);
    GPIO_Init(GPIOA, GPIO_Pin_5, GPIO_Mode_Out_PP_Low_Fast);
    GPIO_Init(GPIOB, GPIO_Pin_3, GPIO_Mode_Out_PP_Low_Fast);
    GPIO_Init(GPIOD, GPIO_Pin_1, GPIO_Mode_Out_PP_Low_Fast);
}

void HC595_Write(unsigned char ucData)
{
    unsigned char i;
    
    CH595_CP_RESET;
    for(i=0;i<8;i++)
    {
        CH595_CLK_RESET;
        if(ucData&0x80)
        {
            CH595_DAT_SET;        
        }
        else
        {
            CH595_DAT_RESET;        
        }
        ucData<<=1;
        CH595_CLK_SET;
    }
}

void LED_Display(void)
{
    static unsigned char ucLedDis_Bit_Index = 0;

    /*Enable LED Display*/
    if(bLED_Enable)
    {
        LED_BIT2_OFF;
        LED_BIT0_OFF;
        LED_BIT1_OFF;
        LED_BIT3_OFF;
        
        /*write data into HC595*/
        HC595_Write(LED_TAB[ucLED_DIS[ucLedDis_Bit_Index]&0x1F]);
        CH595_CP_SET; 

        if(ucLedDis_Bit_Index == 0)
        {
            LED_BIT0_ON;
            ucLedDis_Bit_Index = 1;
        }
        else if(ucLedDis_Bit_Index == 1)
        {
            LED_BIT1_ON;
            ucLedDis_Bit_Index = 2;
        }
        else if(ucLedDis_Bit_Index == 2)
        {
            LED_BIT2_ON;
            ucLedDis_Bit_Index = 3;
        }
        else if(ucLedDis_Bit_Index == 3)
        {
            LED_BIT3_ON;
            ucLedDis_Bit_Index = 0;
        }
        else
        {
            ucLedDis_Bit_Index = 0;
        }
    }
    else/*Disable LED*/
    {
        LED_BIT2_OFF;
        LED_BIT0_OFF;
        LED_BIT1_OFF;
        LED_BIT3_OFF;
        ucLedDis_Bit_Index = 0;      
    }
}

void LED_ChangeFont(unsigned short usLED_Data,unsigned char ucLED_Mode)
{
    /*CARRIER MODE*/
    if(ucTest_Mode == TEST_CARRIER_MODE)
    {
        ucLED_DIS[3] = LED_C;
        ucLED_DIS[2] = LED_h;
        ucLED_DIS[1] = usLED_Data%100/10;
        ucLED_DIS[0] = usLED_Data%10;
    }
    /*RX FUNCTION MODE*/
    else if(Work_State == FUNCTION_RX)
    {
        switch(ucLED_Mode)
        {
            case LED_CHANNEL_MODE:            
                ucLED_DIS[3] = LED_C;
                ucLED_DIS[2] = LETTER_H;
                ucLED_DIS[1] = usLED_Data%100/10;
                ucLED_DIS[0] = usLED_Data%10;      
                break;
            case LED_FUNCTION_MODE: 
                ucLED_DIS[3] = LED_F;
                ucLED_DIS[2] = LED_CP;
                ucLED_DIS[1] = LED_NULL;
                ucLED_DIS[0] = usLED_Data%10;      
                break;
                
            /*CNT :(0000 - 9999)*/
            case LED_CNT_MODE: 
                ucLED_DIS[3] = usLED_Data%10000/1000;
                ucLED_DIS[2] = usLED_Data%1000/100;
                ucLED_DIS[1] = usLED_Data%100/10;
                ucLED_DIS[0] = usLED_Data%10;
                break;
            default:
                break;
        }
    }
    /*TX FUNCTION MODE*/
    else if(Work_State == FUNCTION_TX)
    {
        switch(ucLED_Mode)
        {
            case LED_CHANNEL_MODE:
                ucLED_DIS[3] = LED_C;
                ucLED_DIS[2] = LETTER_H;
                ucLED_DIS[1] = usLED_Data%100/10;
                ucLED_DIS[0] = usLED_Data%10;
                break;
            case LED_FUNCTION_MODE:
                ucLED_DIS[3] = LED_F;
                ucLED_DIS[2] = LED_CP;
                ucLED_DIS[1] = LED_NULL;
                
                if(usLED_Data == 1)
                {
                    ucLED_DIS[0] = LED_A;              
                }
                else if(usLED_Data == 2)
                {
                    ucLED_DIS[0] = LED_B;               
                }
                else if(usLED_Data == 3)
                {
                    ucLED_DIS[0] = LED_C;              
                }            
                break;
            case LED_CNT_MODE:
                if(ucTXMode == MODE_TX_SINGLE)
                {
                    ucLED_DIS[3] = LED_A;                  
                }
                else
                {
                    ucLED_DIS[3] = usLED_Data%10000/1000;                
                }
                
                ucLED_DIS[2] = usLED_Data%1000/100;
                ucLED_DIS[1] = usLED_Data%100/10;
                ucLED_DIS[0] = usLED_Data%10;
                break;
          default:
                break;
        }        
    }
     
}
/*********************************End of file***********************************/