/*******************************************************************************
 * @note Copyright (C) 2020 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file RFAPI.c
 * @brief
 *
 * @history - Vxx.xx ,Date :
*******************************************************************************/

#include "stm8l15x.h"
#include "App.h"
#include "APPSub.h"
#include "LED.h"
#include "Key.h"
#include "stdio.h"
#include "RF.h"

bool  bRFAPI_IRQ = FALSE;
enum  RFAPI_CommuSate  ucRFAPI_STATE;
RF_PAYLOAD  RF_Payload;
uint8_t Channel_Index=5;  

#if(BAND == B315MHz)
/*BAND315MHz*/
    double const FREQ_CHANNEL_TABLE[]={315,317,319,321,323}; 
    double const CARRIER_FREQ_CHANNEL_TABLE[]={315,317,319,321,323};
    
#elif(BAND == B433MHz)
/*BAND433MHz*/
    //double const FREQ_CHANNEL_TABLE[]={400,410,420,450,540};  
    double const FREQ_CHANNEL_TABLE[]={433,434,435,438,440};
    double const CARRIER_FREQ_CHANNEL_TABLE[]={433,432,435,438,440};
   
#elif(BAND == B868MHz)
/*BAND868MHz*/
    double const FREQ_CHANNEL_TABLE[]={868,868.5,869,869.5,870};     
    double const CARRIER_FREQ_CHANNEL_TABLE[]={868,868.5,869,869.5,870};   
  
#elif(BAND == B915MHz)
/*BAND915MHz*/
    double const FREQ_CHANNEL_TABLE[]={916,916.5,917,917.5,918};     
    double const CARRIER_FREQ_CHANNEL_TABLE[]={916,916.5,917,917.5,918};   
#endif

#if(1==EN_DYNPLOAD)
uint8_t  PaylaodLenth=0;
#endif

#if(1==EN_ACK_PAYLOAD) 
uint8_t  PlayLoadAck_Data[64]={0};
#endif
uint8_t TxPayloadLength = PAYLOAD_WIDTH;
uint8_t AckPayloadLength = 0x00;

void RFAPI_ChannelNext(void)
{
  #if DEBUG_ENABLE
  printf("RFAPI_ChannelNext function (1): Channel_Index= %d,sizeof(FREQ_CHANNEL_TABLE) = %d\r\n",Channel_Index,sizeof(FREQ_CHANNEL_TABLE)/sizeof(double));
  #endif
  
  if((Channel_Index == 0)||(Channel_Index >= sizeof(FREQ_CHANNEL_TABLE)/sizeof(double)))
  {
      Channel_Index = sizeof(FREQ_CHANNEL_TABLE)/sizeof(double)-1;
  }
  else
  {
      Channel_Index--;
  }
  
  #if DEBUG_ENABLE
  printf("RFAPI_ChannelNext function (2): Channel_Index= %d\r\n",Channel_Index);
  #endif
  
  RF_SetFreq_Datarate(FREQ_CHANNEL_TABLE[Channel_Index],BAND);
}

void RFAPI_PacketData(void)
{
     uint8_t i; 
    ++RF_Payload.ucPayload[0];
    
    for(i=1;i<sizeof(RF_Payload.ucPayload);i++)
    {
        RF_Payload.ucPayload[i] = 0xC0 | i;
    }
    
    #if DEBUG_PRINT_RTX_BUFFER
    print_RTX_buffer(RF_Payload.ucPayload,sizeof(RF_Payload.ucPayload));
    #endif
}

void RFAPI_TxState(void)
{
    /*if no need to  transmit data*/
    if(!(TX_RQ))                                                               
    {
        return;      
    }
    TX_RQ = FALSE; 
    
    /*prepare data*/
    RFAPI_PacketData();                                                        
       
    #if(1==EN_ACK_PAYLOAD) 
    AckPayloadLength = PAYLOAD_WIDTH;
    #endif  
        
    #if(1==EN_DYNPLOAD)
    if(TxPayloadLength==PAYLOAD_WIDTH) 
    {
        TxPayloadLength = 1;
    }else
    {
        TxPayloadLength = PAYLOAD_WIDTH;
    }
    #endif
        
    RF_Tx_CheckResult(RF_Payload.ucPayload,AckPayloadLength);   
    RF_Tx_TransmintData(RF_Payload.ucPayload,TxPayloadLength);  
}

void  RFAPI_RXState(bool RX_Continue)
{
    if(RF_DumpRxData(RF_Payload.ucPayload,PAYLOAD_WIDTH))
    {
        ucRFAPI_STATE = RFAPI_RX;
        RX_READY = TRUE;
        CE_HIGH;   
        
        #if(1==EN_ACK_PAYLOAD) 
        RF_WriteBuf(W_ACK_PAYLOAD, PlayLoadAck_Data, 16);
        #endif  
        
        RF_WriteReg(FLUSH_RX, 0);	
        
        /*Status*/
        RF_WriteReg(W_REGISTER + STATUS, 0x70);
    }
}

void RFAPI_TestMode(void)
{      
    if(ucTest_Mode == 0)
    {
        /*normal mode*/
        return;                                                                
    }
    else if(ucTest_Mode == TEST_CARRIER_MODE)
    {
        RF_Carrier();   
        LED_ChangeFont(0X00,LED_FUNCTION_MODE); 

        #if DEBUG_ENABLE  
        printf("RFAPI_TestMode - fb = %d,fc=%d \r\n",fb,fc);
        #endif
        
        while(1)
        {    
            Key_Scan(); 
            
            /*if Key Event*/
            if(DATA_READY)                                                                
            {
                DATA_READY = FALSE;
                
                /*if press Key3 button down*/
                if(ucKey_RD == KEY3)                                                        
                {
                    if((Channel_Index == 0)||(Channel_Index >= sizeof(CARRIER_FREQ_CHANNEL_TABLE)/sizeof(double)))
                    {
                        Channel_Index = sizeof(CARRIER_FREQ_CHANNEL_TABLE)/sizeof(double)-1;
                    }
                    else
                    {
                        Channel_Index--;
                    }
                        
                    /*set RF into carry mode*/
                    #if DEBUG_ENABLE
                    printf("RFAPI_TestMode -- CARRIER_FREQ_CHANNEL_TABLE[%d] = %f\r\n",Channel_Index,CARRIER_FREQ_CHANNEL_TABLE[Channel_Index]);
                    #endif
                    
                    RF_SetFreq_Datarate(CARRIER_FREQ_CHANNEL_TABLE[Channel_Index],BAND);
                    
                    #if DEBUG_ENABLE
                    printf("RFAPI_TestMode --fb=%d,fc=%d \r\n",fb,fc);
                    #endif
                    
                    RF_SetChannel(fb,fc);

                    LED_ChangeFont(Channel_Index,LED_FUNCTION_MODE);
                } 
                                                     
          }
          LED_Display(); 
       }     
    }
    /*normal mode*/
    else
    {
        ucTest_Mode = 0;                                                        
    
    }
}

void RFAPI_StateMachine(void)
{
    switch(ucRFAPI_STATE)
    {
      /*RF in TX*/
      case RFAPI_TX:                                                             
          RFAPI_TxState();
          break;
      /*RF in RX*/
      case  RFAPI_RX:                                                              
          RFAPI_RXState(TRUE);
          break;
      /*RF in shutdown*/
      case  RFAPI_HALT:                                                            
          break;
      default:
          break;
    }
}

/******************************End of file************************************/