/*******************************************************************************
 * @note Copyright (C) 2023 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file pan3029_port.h
 * @brief
 *
 * @history - V0.5, 2023-12-22
*******************************************************************************/
#ifndef __pan3029_PORT_H_
#define __pan3029_PORT_H_
#include "stdio.h"
#include "stdint.h"
#include "stdlib.h"
#include "stdbool.h"
#include "math.h"
#include "pan3029.h"
#include "radio.h"
#include "hc32f460_usart.h"
#include "hc32_ddl.h"


#define MODULE_GPIO_TX          0
#define MODULE_GPIO_RX          10
#define MODULE_GPIO_TCXO        3
#define MODULE_GPIO_CAD_IRQ     11

typedef struct {
    void (*antenna_init)(void);
    void (*tcxo_init)(void);
    void (*set_tx)(void);
    void (*set_rx)(void);
    void (*antenna_close)(void);
    void (*tcxo_close)(void);
    uint8_t (*spi_readwrite)(uint8_t tx_data);
    void (*spi_cs_high)(void);
    void (*spi_cs_low)(void);
    void (*delayms)(uint32_t time);
    void (*delayus)(uint32_t time);
} rf_port_t;

extern rf_port_t rf_port;

uint8_t spi_readwritebyte(uint8_t tx_data);
void spi_cs_set_high(void);
void spi_cs_set_low(void);
void rf_delay_ms(uint32_t time);
void rf_delay_us(uint32_t time);
void rf_antenna_init(void);
void rf_tcxo_init(void);
void rf_tcxo_close(void);
void rf_antenna_rx(void);
void rf_antenna_tx(void);
void rf_antenna_close(void);

#endif


