/*******************************************************************************
 * @note Copyright (C) 2023 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file user.c
 * @brief
 *
 * @history - V0.5, 2023-12-22
*******************************************************************************/
#include "pan3029_port.h"
#include "at.h"
#include "user.h"

rfConfig_t gRfConfig = {DEFAULT_FREQ,DEFAULT_CR,DEFAULT_BW,DEFAULT_SF,\
                        PAN3029_MAX_RAMP,CRC_ON,LDR_OFF,MODEM_MODE_NORMAL,8,DCDC_OFF};

void rf_SetUserPara(rfConfig_t *p)
{
	rf_set_mode(PAN3029_MODE_STB3);

	rf_set_para(RF_PARA_TYPE_FREQ, p->freq);
	rf_set_para(RF_PARA_TYPE_CR, p->cr);
	rf_set_para(RF_PARA_TYPE_BW, p->bw);
	rf_set_para(RF_PARA_TYPE_SF, p->sf);
	rf_set_para(RF_PARA_TYPE_TXPOWER, p->pwr);
	rf_set_para(RF_PARA_TYPE_CRC, p->crc);
	rf_set_ldr(p->ldr);
	rf_set_preamble(p->preamble);
	rf_set_modem_mode(p->modemMode);
	rf_set_dcdc_mode(p->dcdc);
}

