/*******************************************************************************
 * @note Copyright (C) 2023 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved.
 *
 * @file radio.c
 * @brief
 *
 * @history - V0.4, 2023-11-17
*******************************************************************************/
#include "hc32_ddl.h"
#include "radio.h"
#include "pan3029.h"

uint8_t tx_test_buf[256];
uint32_t fre_lib[2] = {480250000,473550000};

extern struct RxDoneMsg RxDoneParams;
extern uint32_t cad_tx_timeout_flag;

void SysTick_IrqHandler(void)
{
    SysTick_IncTick();
}

int32_t main(void)
{
    uint32_t ret = 0;
    uint32_t cnt = 0;
    uint32_t i=0;
    uint32_t dat[100];
    uint8_t freq_cnt = 0;

    BSP_CLK_Init();
    Timer4_Init();
    Timer6_Cfg();
    SysTick_Init(1000u);
    SysTick_IncTick();

    BSP_GPIO_Init();
    RF_IRQ_Init();
    BSP_LED_Init();
    Spi_Config();
    Uart_Config();
    CAD_GPIO_Init();

    for(i = 0; i < 256; i++)
    {
        tx_test_buf[i] = i;
    }

    for(i=0; i<100; i++)
    {
        dat[i] = (rand()%255 + 1);//len
    }

    ret = rf_init();
    if(ret != OK)
    {
        DDL_Printf(" RF Init Fail");
        while(1);
    }
    rf_set_default_para();
    rf_set_preamble(170);//table
    rf_enter_continous_tx();

    rf_set_transmit_flag(RADIO_FLAG_TXDONE);//start

    DDL_Printf("TX start: %d, %d\r\n",fre_lib[0],fre_lib[1]);

    while (1)
    {
        rf_irq_process();
        if(rf_get_transmit_flag() == RADIO_FLAG_TXDONE)
        {
            BSP_LED_Toggle();
            rf_set_transmit_flag(RADIO_FLAG_IDLE);

            i++;
            if(i>=100)i=0;

            cnt++;
            tx_test_buf[0] = cnt>>8;
            tx_test_buf[1] = cnt;
            tx_test_buf[2] = dat[i];//len

            rf_delay_ms(dat[i]+150);
            rf_set_mode(PAN3029_MODE_STB3);
            freq_cnt = rand()%9;
            freq_cnt %= 2;
            if(freq_cnt)
            {
                tx_test_buf[3] = freq_cnt;
                rf_set_para(RF_PARA_TYPE_FREQ, fre_lib[freq_cnt]);
            }
            else
            {
                tx_test_buf[3] = freq_cnt;
                rf_set_para(RF_PARA_TYPE_FREQ, fre_lib[freq_cnt]);
            }

            check_cad_tx_inactive();
            while(1)
            {
                if(cad_tx_timeout_flag == MAC_EVT_TX_CAD_TIMEOUT)
                {
                    cad_tx_timeout_flag = MAC_EVT_TX_CAD_NONE;
                    rf_enter_continous_tx();
                    if(rf_continous_tx_send_data(tx_test_buf, dat[i]) != OK)
                    {
                        DDL_Printf("tx fail \r\n");
                    }
                    else
                    {
                        DDL_Printf("Tx cnt %d, len %d, fre %d \r\n", cnt, dat[i], fre_lib[freq_cnt]);
                    }
                    break;

                } else if(cad_tx_timeout_flag == MAC_EVT_TX_CAD_ACTIVE)
                {
                    cad_tx_timeout_flag = MAC_EVT_TX_CAD_NONE;
                    rf_set_mode(PAN3029_MODE_STB3);
                    rf_delay_ms(dat[i]+150);
                    rf_set_transmit_flag(RADIO_FLAG_TXDONE);
                    break;
                }
            }
        }
    }
}

/*******************************************************************************
 * EOF (not truncated)
 ******************************************************************************/
