//===================================================================================//
//  * @file           main.c
//  * @author         liuhaibing
//  * @version        V1.0.0
//  * @date           2021/05/14
//  * @brief          xn297l ֤
//===================================================================================//
/* Includes ------------------------------------------------------------------*/
#include "stm8l15x.h"
#include "rf.h"

#define  KEY  GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_2)


uint8_t work_mode,hop_index=0;
uint8_t RF_cal_data_tx[]= {0xF6,0x3F,0x5D};
uint8_t RF_cal_data_rx[]= {0x06,0x3F,0x5D};
uint8_t tx_hop_frq[10]={20,26,30,34,40,46,50,54,58,65};

/******************************************************************************/
//            IO_Port_Initial
//            Initial all gpio: set RESET_PIN to Output
/******************************************************************************/
void  IO_Init(void)
{
    //CLK_PeripheralClockConfig(CLK_Peripheral_TypeDef CLK_Peripheral, FunctionalState NewState);
    GPIO_DeInit(GPIOA);  
    GPIO_DeInit(GPIOB);   
    GPIO_DeInit(GPIOC);   
    GPIO_DeInit(GPIOD); 
}

void key_init(void)
{
    GPIO_Init( GPIOA, GPIO_Pin_2, GPIO_Mode_In_PU_No_IT); 
}


void MCU_Init(void)
{
    __disable_interrupt();
    CLK_DeInit();
    CLK_HSICmd(ENABLE);
    CLK_SYSCLKDivConfig(CLK_SYSCLKDiv_1);
    CLK_ClockSecuritySystemEnable();
    __enable_interrupt();  
    
    IO_Init();
    key_init();
}


void rf_mode_swith(void)
{
    switch(work_mode)
    {
        case 1:  //ģʽ1زģʽƵ2420
           RF_Init();
           RF_Carrier(20); 
        break;
        
        case 2:  //ģʽ2زģʽƵ2440
           RF_Init();
           RF_Carrier(40); 
        break;
        
        case 3:  //ģʽ3زģʽƵ2465
           RF_Init();
           RF_Carrier(65);
        break;
        
        case 4:  //ģʽ4ƷģʽƵ2420
           RF_Init();
           RF_TxMode(); 
           RF_SetChannel(20);
           RF_WriteBuf(W_REGISTER + RF_CAL,  RF_cal_data_tx,  sizeof(RF_cal_data_tx));
        break;
        
        case 5: //ģʽ5ƷģʽƵ2440
           RF_Init();
           RF_TxMode(); 
           RF_SetChannel(40); 
           RF_WriteBuf(W_REGISTER + RF_CAL,  RF_cal_data_tx,  sizeof(RF_cal_data_tx));
        break;
        
        case 6:  //ģʽ6ƷģʽƵ2465
           RF_Init();
           RF_TxMode(); 
           RF_SetChannel(65); 
           RF_WriteBuf(W_REGISTER + RF_CAL,  RF_cal_data_tx,  sizeof(RF_cal_data_tx));
        break;
        
        case 7:  //ģʽ7ƵģʽƵ2420
           RF_Init();
           RF_RxMode(); 
           RF_SetChannel(20); 
           RF_WriteBuf(W_REGISTER + RF_CAL,  RF_cal_data_rx,  sizeof(RF_cal_data_rx));
        break;
        
        case 8: //ģʽ8ƵģʽƵ2440
           RF_Init();
           RF_RxMode(); 
           RF_SetChannel(40); 
           RF_WriteBuf(W_REGISTER + RF_CAL,  RF_cal_data_rx,  sizeof(RF_cal_data_rx));  
        break;
        
        case 9: //ģʽ9ƵģʽƵ2465
           RF_Init();
           RF_RxMode(); 
           RF_SetChannel(65); 
           RF_WriteBuf(W_REGISTER + RF_CAL,  RF_cal_data_rx,  sizeof(RF_cal_data_rx)); 
        break;
        
        case 10: //ģʽ10ƵģʽƵ2420-2465
           RF_Init();
           RF_TxMode(); 
           RF_SetChannel(20);
           RF_WriteBuf(W_REGISTER + RF_CAL,  RF_cal_data_tx,  sizeof(RF_cal_data_tx)); 
        break;
    }
}


void key_scan(void)
{
    if(KEY==0)
    {
        delay_ms(10);
        if(KEY==0)
        {
            while(!KEY);
            work_mode++;
            if(work_mode>10)
              work_mode=1;
            rf_mode_swith();
        }
    }
}




uint8_t tx_data[PAYLOAD_WIDTH]={0x12,0x34,0x56,0x78,0x12,0x34,0x56,0x78};

/******************************************************************************/
// @brief  main֤ԣ10ģʽûɰл
// @param  None
// @retval None            
/******************************************************************************/
void main(void)
{  
   /****mcu init*********/ 
    MCU_Init();
   /*****rf init***********/    
    while(!RF_Init());
    RF_Carrier(20);  
    work_mode=1;
    while(1)
    {
        key_scan();
        switch(work_mode)
        {
            case 4:
               RF_TxData(tx_data, PAYLOAD_WIDTH);
               delay_ms(8);
            break;
            
            case 5:
               RF_TxData(tx_data, PAYLOAD_WIDTH);
               delay_ms(8); 
            break;
            
            case 6:
               RF_TxData(tx_data, PAYLOAD_WIDTH);
               delay_ms(8); 
            break;
            
            case 10:
               hop_index++;
               if(hop_index>9)
                 hop_index=0;
               RF_SetChannel(tx_hop_frq[hop_index]); 
               RF_TxData(tx_data, PAYLOAD_WIDTH);
               delay_ms(50); 
            break;
        }
        
    }
}		

/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/




