//===================================================================================//
//  * @file           main.c
//  * @author         liuhaibing
//  * @version        V1.0.0
//  * @date           2021/05/14
//  * @brief          xn297l ̬paylaod(ǿģʽ-˫ͨ)
//===================================================================================//
/* Includes ------------------------------------------------------------------*/
#include "stm8l15x.h"
#include "rf.h"


/******************************************************************************/
//            IO_Port_Initial
//            Initial all gpio: set RESET_PIN to Output
/******************************************************************************/
void  IO_Init(void)
{
    //CLK_PeripheralClockConfig(CLK_Peripheral_TypeDef CLK_Peripheral, FunctionalState NewState);
    GPIO_DeInit(GPIOA);  
    GPIO_DeInit(GPIOB);   
    GPIO_DeInit(GPIOC);   
    GPIO_DeInit(GPIOD); 
}


void MCU_Init(void)
{
    __disable_interrupt();
    CLK_DeInit();
    CLK_HSICmd(ENABLE);
    CLK_SYSCLKDivConfig(CLK_SYSCLKDiv_1);
    CLK_ClockSecuritySystemEnable();
    __enable_interrupt();  
    
    IO_Init();
}

uint8_t tx_data[PAYLOAD_WIDTH]={0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
uint8_t ack_data[PAYLOAD_WIDTH]={0};
uint8_t send_length=1;
/******************************************************************************/
// @brief  mainMCUʼRFʼΪģʽ
// @param  None
// @retval None            
/******************************************************************************/
void main(void)
{  
   /****mcu init*********/ 
    MCU_Init();
   /*****rf init***********/    
    while(!RF_Init());
    RF_TxMode(); 
  
    while(1)
    {
        if(send_length++>7)
          send_length=1;
        RF_TxData( tx_data, send_length); 
        RF_TX_CheckResult(ack_data,PAYLOAD_WIDTH);
        
        delay_ms(10);
    }
}		

/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/




