# <center >XN297L enhance mode通信</center >

### 一、简介

本例程演示xn297l 增强(双向向)通信功能，TX首先发射数据，然后芯片自动切换至接收状态，接收指定时间后自动切回发射。相反，RX首先处于接收状态，当收到数据后会自动切换到发射状态，此时如果用户不使用W_ACK_PAYLOAD命令往TX_FIFO写数据，RX只回发ack应答信号。如果往TX_FIFO写了数据，RX会回复ack和ack paylaod。具体描述请参考《XN297L产品说明书_v4.8-ZH.pdf》文档中增强模式部分说明。增强模式的优势在于做双向通信时切换的时间比手动快，同样，因为芯片是自动切换发射/接收状态，一定要了解增强模式下的时序切换。

### 二、条件说明

    SPI类型：4线spi
    RF速率：250K
    CE模式:  软件CE
    数据长度：8bytes
    频点：2478Mhz
    功率：9dbm
### 三、接口(移植)实现

1、根据实际使用的MCU实现rf.c中延时函数delay_ms()和delay_100us();

2、根据实际使用情况修改rf.c中SPI_init函数

![spi_init](img\spi_init.png)

修改rf.h中RF相关IO口的定义。

<img src="img\io_set.png" alt="io_set" style="zoom:150%;" />

### 四、应用范例

与普通模式设置不同，增强模式在初始化的时候需要将EN_AA和SETUP_RETR寄存器设置非0值。如果RX端需要回复ack paylaod，需要将宏定义EN_ACK_PAYLAOD置1

![rf_init](img\rf_init.png)

TX端：上电首先为发射状态，RF_TxData()发送数据，RF_TX_CheckResult()查询发送和接收的结果。

![tx](img\tx.png)

RX端：设置为接收模式，轮询是否有数据接收到。如果收到数据，先读取数据，然后调用W_ACK_PAYLAOD写回应数据。

![rx](img\rx.png)

上面提到了，芯片接收到数据后是自动切换到发射状态的，所以一定要在芯片发射之前(按照当前demo的参数设置大约是RX收到数据后775us内)将数据写入到TX_FIFO中（下图SEND_ACK_TIME前），否则即使你写入了数据，但是芯片已经发送完了，对端也只能收到ack信号而没有payload数据。

![enhance](img\enhance.png)

芯片自动切换的时间可以根据BB_CAL参数计算出来，如果客户使用的SPI速率比较慢，比如500K以下，这样会导致写FIFO和读FIFO的时间变长，为了让TX能收到ack payload数据，建议RX收到数据后，先回发数据，再读取收到的数据。具体操作为将RF_DumpRxData（）函数中的读取操作放到回发数据之后，如下：

![tx_first](img\tx_first.png)

逻辑分析仪抓取SPI如下：

![logic](img\logic.png)



### 五、参考文档

《XN297L产品说明书_v4.8-ZH.pdf》

《11_XN297L 250Kbps使用说明_V1p1.pdf》