# <center >XN297L 被动跳频</center >

### 一、简介

本例程演示xn297l 被动跳频功能

被动跳频是一种当链路丢失，收发双方才会按照约定频率表及规则跳频的一种通信方式。

TX端：每10ms发射一次数据，使用增强模式，发射完成后检查是否有收到回应的ack信号，如果有，就不进行跳频。如果未收到应答ack，则跳到下一个频点。

RX端：一直处于接收数据的状态，如果10ms（从上一次收到数据开始计时)内未收到数据，则跳到下一个频点，同时丢包计数加一，当丢包达到3后，RX间隔30ms切换一次频点。如果RX收到数据，则不进行跳频处理，并且清空之前的丢包计数值，并重新开始计时10ms，判断是否有数据丢失。



### 二、条件说明

    SPI类型：4线spi
    RF速率：250K
    CE模式:  软件CE
    数据长度：8bytes
    频点：2420Mhz、2440Mhz、2465Mhz
    功率：9dbm
### 三、接口(移植)实现

1、根据实际使用的MCU实现rf.c中延时函数delay_ms()和delay_100us();

2、根据实际使用情况修改rf.c中SPI_init函数

![spi_init](img\spi_init.png)

修改rf.h中RF相关IO口的定义。

<img src="img\io_set.png" alt="io_set" style="zoom:150%;" />

3、根据实际使用的MCU实现main.c中定时器相关操作，具体为实现一个1ms的定时器，以及定时器的中断处理。

### 四、应用范例

TX端：设置为发射模式，每10ms发射一次数据，发射完成后如果没收到ack,则切换至下一个频点，如果收到ack则在当前频点继续发送数据。

![tx](img\tx.png)

RX端：上电设置为接收模式，如果收到数据后芯片自动回复应答ack，如果在10ms内没收到数据则切换至下一个频点。

![rx](img\rx.png)



### 五、参考文档

01_SDK\2M_1M\4_LINE_SPI\hopping\XN297L跳频参考.pdf

