# <center >PA使用</center >

### 一、简介

本例程主要演示发射端使用IRQ脚控制PA

XN297L 控制 PA 的优势，在于 IRQ 不仅仅是中断输出引脚，还可以通过寄存器配置后，设置为 EN_PA 的功能。硬件上 IRQ 连接 TXEN,可以自动控制 PA 的 TX 状态打开和关闭。

### 二、条件说明

    SPI类型：4线spi
    RF速率：250K
    CE模式:  软件CE
    数据长度：8bytes
    频点：2478Mhz
    功率：-1dbm
### 三、接口(移植)实现

1、根据实际使用的MCU实现rf.c中延时函数delay_ms()和delay_100us();

2、根据实际使用情况修改rf.c中SPI_init函数

![spi_init](img\spi_init.png)

修改rf.h中RF相关IO口的定义。

<img src="img\io_set.png" alt="io_set" style="zoom:150%;" />

### 四、应用范例

TX端：

（1）在RF初始化中设置FEATURE寄存器的BIT6为1，其它设置与正常配置一致即可。

![rf_init](img\rf_init.png)

（2）加PA的情况下，xn297l的功率不宜设置太大，建议设置0dbm或以下。

发射数据时，EN_PA 信号 在 EX_PA_TIME 结束之后，TX_SETUP_TIME 开始之前升高，在数据发送完之后拉低。如下图所示：

<img src="img\pa.png" alt="pa" style="zoom:200%;" />



逻辑分析仪抓取时序如下：

![pa_logic](img\pa_logic.png)



### 五、参考文档

《XN297L PA应用指南.pdf》

