//===================================================================================//
//  * @file           main.c
//  * @author         liuhaibing
//  * @version        V1.0.3
//  * @date           2021/08/13
//  * @brief          xn297l 
//===================================================================================//
/* Includes ------------------------------------------------------------------*/
#include "stm8l15x.h"
#include "rf.h"
#include <string.h>


#define  KEY_PAIR       GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_2)
#define  KEY_CONTROL    GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_3)

#define CMD_PAIR_CODE      0xA0
#define CMD_CONTROL_CODE   0xA1


enum workMode
{       
   CONTROL_MODE,
   PAIR_MODE,
};

uint8_t work_mode=PAIR_MODE;

uint8_t rolling_code[5]={0xAA,0xAA,0xAA,0xAA,0xAA};  //һ5ֽڴСģֵʵӦиݾMCU1-NֽΪ룬֤ÿMCUΨһ
uint8_t unique_id[5]={0};   //MCUΨһIDͨΪݱʶʹ
uint8_t public_addr[5] = {0xCC,0xCC,0xCC,0xCC,0xCC}; //빫ַ


uint8_t application_data[PAYLOAD_WIDTH-1]={0x01,0x02,0x03,0x04,0x05,0x06,0x07};
uint8_t tx_data[PAYLOAD_WIDTH]; 

/******************************************************************************/
//            IO_Port_Initial
//            Initial all gpio: set RESET_PIN to Output
/******************************************************************************/
void  IO_Init(void)
{
    //CLK_PeripheralClockConfig(CLK_Peripheral_TypeDef CLK_Peripheral, FunctionalState NewState);
    GPIO_DeInit(GPIOA);  
    GPIO_DeInit(GPIOB);   
    GPIO_DeInit(GPIOC);   
    GPIO_DeInit(GPIOD); 
}

void key_init(void)
{
    GPIO_Init( GPIOA, GPIO_Pin_2, GPIO_Mode_In_PU_No_IT);  //KEY_PAIR
    GPIO_Init( GPIOA, GPIO_Pin_3, GPIO_Mode_In_PU_No_IT);  //KEY_DATA_SEND
}



void MCU_Init(void)
{
    __disable_interrupt();
    CLK_DeInit();
    CLK_HSICmd(ENABLE);
    CLK_SYSCLKDivConfig(CLK_SYSCLKDiv_1);
    CLK_ClockSecuritySystemEnable();
    __enable_interrupt();  
    
    IO_Init();
    key_init();
}

//ȡоƬΨһID̽ģĹֵΪID
void get_rolling(void)
{
    memcpy(unique_id,rolling_code,sizeof(rolling_code)); 
}


void control_mode_set(void)
{
    work_mode=CONTROL_MODE;
    RF_WriteBuf(W_REGISTER + TX_ADDR,  unique_id, sizeof(unique_id)); //ʹԼIDΪַ
    tx_data[0]=CMD_CONTROL_CODE;                                                 //
    memcpy(&tx_data[1],application_data,sizeof(application_data));       //Ӧ
}

void pair_mode_set(void)
{
    work_mode=PAIR_MODE;
    RF_WriteBuf(W_REGISTER + TX_ADDR, public_addr, sizeof(public_addr)); //ʱʹùַ
    tx_data[0]=CMD_PAIR_CODE;                                            //
    memcpy(&tx_data[1],unique_id,sizeof(unique_id));               //ԼIDնˣʵӦпԽƵϢһ͹ȥ
}


void key_scan(void)
{
    if(KEY_CONTROL==0)
    {
        delay_ms(10);
        if(KEY_CONTROL==0)
        {
            while(!KEY_CONTROL);
            control_mode_set();
        }
    }
    
    if(KEY_PAIR==0)
    {
        delay_ms(10);
        if(KEY_PAIR==0)
        {
            while(!KEY_PAIR);
            pair_mode_set();     
        }
    }
}

/******************************************************************************/
// @brief  mainMCUʼRFʼΪģʽ
// @param  None
// @retval None            
/******************************************************************************/
void main(void)
{  
   /****mcu init*********/ 
    MCU_Init();
   /*****rf init***********/    
    while(!RF_Init());
    RF_TxMode(); 
      
    get_rolling();
    pair_mode_set(); //ϵʼΪģʽ
    
    while(1)
    {
        key_scan();   //лģʽ߿ģʽ
        RF_TxData(tx_data,PAYLOAD_WIDTH);
        delay_ms(10);
    }
}		

/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/




