//===================================================================================//
//  * @file           main.c
//  * @author         liuhaibing
//  * @version        V1.0.0
//  * @date           2021/05/14
//  * @brief          xn297l ˫ͨ(ǿģʽ)
//===================================================================================//
/* Includes ------------------------------------------------------------------*/
#include "stm8l15x.h"
#include "rf.h"


/******************************************************************************/
//            IO_Port_Initial
//            Initial all gpio: set RESET_PIN to Output
/******************************************************************************/
void  IO_Init(void)
{
    //CLK_PeripheralClockConfig(CLK_Peripheral_TypeDef CLK_Peripheral, FunctionalState NewState);
    GPIO_DeInit(GPIOA);  
    GPIO_DeInit(GPIOB);   
    GPIO_DeInit(GPIOC);   
    GPIO_DeInit(GPIOD); 
}


void MCU_Init(void)
{
    __disable_interrupt();
    CLK_DeInit();
    CLK_HSICmd(ENABLE);
    CLK_SYSCLKDivConfig(CLK_SYSCLKDiv_1);
    CLK_ClockSecuritySystemEnable();
    __enable_interrupt();  
    
    IO_Init();
}

uint8_t rx_data[PAYLOAD_WIDTH]={0};
uint8_t ack_data[ACK_PAYLOAD_WIDTH]={0xAA,0xBB,0xCC,0xDD,0x12,0x34,0x56,0x78};
/******************************************************************************/
// @brief  mainMCUʼRFʼΪģʽ
// @param  None
// @retval None            
/******************************************************************************/
void main(void)
{  
   /****mcu init*********/ 
    MCU_Init();
   /*****rf init***********/    
    while(!RF_Init());
    RF_RxMode(); 
  
    while(1)
    {
        if(RF_DumpRxData(rx_data, PAYLOAD_WIDTH))
        {
            #if(EN_ACK_PAYLOAD ==1)
               RF_WriteBuf(W_ACK_PAYLOAD, ack_data, ACK_PAYLOAD_WIDTH); 
               delay_ms(2);
            #endif
            RF_ClearFIFO();
            RF_ClearStatus();          
        }
    }
}		

/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/




