# <center >REUSE_TX_PL命令使用</center >

### 一、简介

XN297L芯片中有一个命令REUSE_TX_PL(0xE3)，这条命令可以实现的功能是，在CE为高的时候可以不断发送上一包的数据（没有清FIFO），所以在TX端可以适当利用这一条命令来达到增加发包频率的目的。

### 二、条件说明

    SPI类型：3线spi
    RF速率：250K
    CE模式:  软件CE
    数据长度：8bytes
    频点：2478Mhz
    功率：9dbm
### 三、接口(移植)实现

1、根据实际使用的MCU实现rf.c中延时函数delay_ms()和delay_100us();

2、根据实际使用情况修改rf.c中SPI_init函数

![spi_init](img\spi_init.png)

修改rf.h中RF相关IO口的定义。

<img src="img\io_set.png" alt="io_set" style="zoom:150%;" />

### 四、应用范例

TX端：设置为发射模式，间隔10ms发送一次数据

![tx](img\tx.png)

在RF_TXData函数中，判断上一次数据发送成功后，调用REUSE_TX_PL命令，使芯片不断重发上一次数据。这里使用10ms延时来观察重发的情况，实际应用中可以在调用重发命令后直接退出发射函数去处理自己的逻辑（芯片会一直保持在重发模式），等下一次调用RF_TXData时先清掉TX FIFO和status,再开始新数据的发送（即把函数末尾四行放到函数开头处）。

![reuse](img\reuse.png)

RX端：设置为接收模式，轮询是否有数据接收到

![rx](img\rx.png)

使用逻辑分析仪抓取SPI时序，如下所示：

![logic](img\logic.png)

### 五、参考文档

《09_XN297LBW使用手册_V1p3.pdf》

《11_XN297L 250Kbps使用说明_V1p1.pdf》