# <center >硬件CE使用</center >

### 一、简介

本例程演示xn297l 普通(单向)通信功能，使用IO口控制CE信号，TX发射数据，RX接收数据。

软件CE和硬件CE使用区别：

1、功能上没有什么区别，操作方式上一个使用IO口控制CE信号，一个使用软件命令控制CE信号。XN297L SOP8封装没有硬件CE脚，必须使用软件CE。

2、软件CE和硬件CE使用上，除了CE_HIGH和CE_LOW定义不同之外，还需要关注寄存器FEATURE(0x1D)的bit5,这个位决定了哪种模式生效，换句话说在操作CE之前，务必确保FEATURE寄存器有被正确设置。

<img src="img\reg_feature_set.png" alt="reg_feature_set" style="zoom:150%;" />

### 二、条件说明

    SPI类型：4线spi
    RF速率：250K
    CE模式:  硬件CE
    数据长度：8bytes
    频点：2478Mhz
    功率：9dbm
### 三、接口(移植)实现

1、根据实际使用的MCU实现rf.c中延时函数delay_ms()和delay_100us();

2、根据实际使用情况修改rf.c中SPI_init函数

![spi_init](img\spi_init.png)

修改rf.h中RF相关IO口的定义。

<img src="img\io_set.png" alt="io_set" style="zoom:150%;" />

### 四、应用范例

TX端：设置为发射模式，间隔10ms发送一次数据

![tx](img\tx.png)

RX端：设置为接收模式，轮询是否有数据接收到

![rx](img\rx.png)

### 五、参考文档

《11_XN297L 250Kbps使用说明_V1p1.pdf》