# <center >RX多通道使用</center >

### 一、简介

本例程演示RX多通道使用

xn297l 做接收时，共有6个通道可以使用，每个通道可以绑定不同的地址。其中通道0,1可以任意设置（5bytes）。通道2,3,4,5的高4 bytes默认与通道1相同，仅最低字节可以更改。接收端收到数据后，可以通过STATUS寄存器的位\<3:1>读出是被哪个通道接收到。

### 二、条件说明

    SPI类型：4线spi
    RF速率：250K
    CE模式:  软件CE
    数据长度：8bytes
    频点：2478Mhz
    功率：9dbm
### 三、接口(移植)实现

1、根据实际使用的MCU实现rf.c中延时函数delay_ms()和delay_100us();

2、根据实际使用情况修改rf.c中SPI_init函数

![spi_init](img\spi_init.png)

修改rf.h中RF相关IO口的定义。

<img src="img\io_set.png" alt="io_set" style="zoom:150%;" />

### 四、应用范例

TX端：设置为发射模式，在发射数据之前设置不同的发射地址，会被接收端对应的通道收到。

![tx](img\tx.png)

RX端：初始化时设置不同通道的地址和接收长度

![rx_init](img\rx_init.png)

收到数据时可以读出当前的通道号

![rx](img\rx.png)

### 五、参考文档

《11_XN297L 250Kbps使用说明_V1p1.pdf》