//===================================================================================//
//  * @file           main.c
//  * @author         liuhaibing
//  * @version        V1.0.0
//  * @date           2021/05/14
//  * @brief          xn297l ͨ
//===================================================================================//
/* Includes ------------------------------------------------------------------*/
#include "stm8l15x.h"
#include "rf.h"


/******************************************************************************/
//            IO_Port_Initial
//            Initial all gpio: set RESET_PIN to Output
/******************************************************************************/
void  IO_Init(void)
{
    //CLK_PeripheralClockConfig(CLK_Peripheral_TypeDef CLK_Peripheral, FunctionalState NewState);
    GPIO_DeInit(GPIOA);  
    GPIO_DeInit(GPIOB);   
    GPIO_DeInit(GPIOC);   
    GPIO_DeInit(GPIOD); 
}


void MCU_Init(void)
{
    __disable_interrupt();
    CLK_DeInit();
    CLK_HSICmd(ENABLE);
    CLK_SYSCLKDivConfig(CLK_SYSCLKDiv_1);
    CLK_ClockSecuritySystemEnable();
    __enable_interrupt();  
    
    IO_Init();
}

uint8_t tx_data[PAYLOAD_WIDTH]={0x12,0x34,0x56,0x78,0x12,0x34,0x56,0x78};
uint8_t TX_ADDRESS_0[5] = {0xC0,0xCC,0xCC,0xCC,0xCC};
uint8_t TX_ADDRESS_1[5] = {0xC1,0xCC,0xCC,0xCC,0xCC};
uint8_t TX_ADDRESS_2[5] = {0xC2,0xCC,0xCC,0xCC,0xCC};
uint8_t TX_ADDRESS_3[5] = {0xC3,0xCC,0xCC,0xCC,0xCC};
uint8_t TX_ADDRESS_4[5] = {0xC4,0xCC,0xCC,0xCC,0xCC};
uint8_t TX_ADDRESS_5[5] = {0xC5,0xCC,0xCC,0xCC,0xCC};

/******************************************************************************/
// @brief  mainMCUʼRFʼΪģʽ
// @param  None
// @retval None            
/******************************************************************************/
void main(void)
{  
   /****mcu init*********/ 
    MCU_Init();
   /*****rf init***********/    
    while(!RF_Init());
    RF_TxMode(); 
    
    //ĲͬķַᱻRXͬͨյ
    RF_WriteBuf(W_REGISTER + TX_ADDR, TX_ADDRESS_1, sizeof(TX_ADDRESS_1));	
    while(1)
    {
        RF_TxData( tx_data,  PAYLOAD_WIDTH);
        delay_ms(10);
    }
}		

/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/




