//===================================================================================//
//  * @file           main.c
//  * @author         liuhaibing
//  * @version        V1.0.3
//  * @date           2021/08/13
//  * @brief          xn297l Ƶ
//===================================================================================//
/* Includes ------------------------------------------------------------------*/
#include "stm8l15x.h"
#include "stm8l15x_tim2.h"
#include "rf.h"
#include "string.h"

#define HOP_NUM    3
uint16_t timer_cnt=0;
uint8_t send_interval=10;
uint8_t send_seq=1;
uint8_t flag_send=0;
uint8_t hop_index=0;
uint8_t hop_table[HOP_NUM]={20,40,65};


/******************************************************************************/
//            IO_Port_Initial
//            Initial all gpio: set RESET_PIN to Output
/******************************************************************************/
void  IO_Init(void)
{
    //CLK_PeripheralClockConfig(CLK_Peripheral_TypeDef CLK_Peripheral, FunctionalState NewState);
    GPIO_DeInit(GPIOA);  
    GPIO_DeInit(GPIOB);   
    GPIO_DeInit(GPIOC);   
    GPIO_DeInit(GPIOD); 
}


/******************************************************************************/
//            Timer_Iniital
//            Initial all timers: 
//                Timer2: 1ms AutoReload with Interrupt
/******************************************************************************/
void Timer_Init(void)
{
    CLK_PeripheralClockConfig(CLK_Peripheral_TIM2, ENABLE);  
    TIM2_Cmd(DISABLE);
    TIM2_DeInit();
    TIM2_TimeBaseInit(TIM2_Prescaler_16, TIM2_CounterMode_Up, 1000);
    TIM2_ARRPreloadConfig(ENABLE);
    TIM2_ClearFlag(TIM2_FLAG_Update);
    TIM2_ITConfig(TIM2_IT_Update, ENABLE);
    TIM2_SetCounter(0);
    
    TIM2_Cmd(ENABLE);
}

/**
  * @brief TIM2 Update/Overflow/Trigger/Break Interrupt routine.
  * @par Parameters:
  * None
  * @retval 
  * None
  */
INTERRUPT_HANDLER(TIM2_UPD_OVF_TRG_BRK_IRQHandler,19)
{
    TIM2_ClearITPendingBit(TIM2_IT_Update);
    timer_cnt++;
    if(timer_cnt>=send_interval)
    {
       timer_cnt=0;
       flag_send=1;    
    }
   
}

void MCU_Init(void)
{
    __disable_interrupt();
    CLK_DeInit();
    CLK_HSICmd(ENABLE);
    CLK_SYSCLKDivConfig(CLK_SYSCLKDiv_1);
    CLK_ClockSecuritySystemEnable();
    __enable_interrupt();  
    
    IO_Init();
    Timer_Init();
}

uint8_t tx_data[PAYLOAD_WIDTH]={0x12,0x34,0x56,0x78,0x12,0x34,0x56,0x78};
uint8_t rx_data[PAYLOAD_WIDTH]={0};
/******************************************************************************/
// @brief  mainMCUʼRFʼΪģʽ
// @param  None
// @retval None            
/******************************************************************************/
void main(void)
{  
   /****mcu init*********/ 
    MCU_Init();
   /*****rf init***********/    
    while(!RF_Init());
    RF_TxMode(); 
    uint8_t test_value=0; 
    while(1)
    {   
         if(flag_send)  //10msһ
         {
            flag_send=0;
            test_value++;
            memset(tx_data,test_value,PAYLOAD_WIDTH);                           //ÿη䲻ͬݣԶ 
            tx_data[PAYLOAD_WIDTH-1]=send_seq;                                  //10msļΪ1,2,3ݰ
            RF_TxData(tx_data,PAYLOAD_WIDTH);
            send_seq++;                                                          
            if(send_seq>=4)
            {
                send_seq=1;
                hop_index++;
                if(hop_index>2)
                  hop_index=0;
                RF_SetChannel(hop_table[hop_index]);                            //һ(3)һƵ
            }          
         }

    }
}		

/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/




