//===================================================================================//
//  * @file           main.c
//  * @author         liuhaibing
//  * @version        V1.0.3
//  * @date           2021/08/13
//  * @brief          xn297l 룬ÿϵ¶
//===================================================================================//
/* Includes ------------------------------------------------------------------*/
#include "stm8l15x.h"
#include "rf.h"

#define CMD_PAIR_CODE      0xA0
#define CMD_CONTROL_CODE   0xA1

enum workMode
{       
   CONTROL_MODE,
   PAIR_MODE,
};

uint8_t work_mode=PAIR_MODE;
uint8_t public_addr[5] = {0xCC,0xCC,0xCC,0xCC,0xCC}; //빫ַ

/******************************************************************************/
//            IO_Port_Initial
//            Initial all gpio: set RESET_PIN to Output
/******************************************************************************/
void  IO_Init(void)
{
    //CLK_PeripheralClockConfig(CLK_Peripheral_TypeDef CLK_Peripheral, FunctionalState NewState);
    GPIO_DeInit(GPIOA);  
    GPIO_DeInit(GPIOB);   
    GPIO_DeInit(GPIOC);   
    GPIO_DeInit(GPIOD); 
}


void MCU_Init(void)
{
    __disable_interrupt();
    CLK_DeInit();
    CLK_HSICmd(ENABLE);
    CLK_SYSCLKDivConfig(CLK_SYSCLKDiv_1);
    CLK_ClockSecuritySystemEnable();
    __enable_interrupt();  
    
    IO_Init();
}

uint8_t rx_data[PAYLOAD_WIDTH]={0};


void pair_mode_set(void)
{
    work_mode=PAIR_MODE;
    RF_WriteBuf(W_REGISTER + RX_ADDR_P0, public_addr, sizeof(public_addr));     //ڹַն
}


void  rf_pair_handle(uint8_t*buf)
{
   RF_WriteBuf(W_REGISTER + RX_ADDR_P0, &buf[1], 5);                            //յָеIDΪµĽյַ
   work_mode=CONTROL_MODE;
}

void rf_data_parse(void)
{
    
}

/******************************************************************************/
// @brief  mainMCUʼRFʼΪģʽ
// @param  None
// @retval None            
/******************************************************************************/
void main(void)
{  
   /****mcu init*********/ 
    MCU_Init();
   /*****rf init***********/    
    while(!RF_Init());
    RF_RxMode(); 
    
    pair_mode_set();
    
    while(1)
    {
        if(RF_DumpRxData(rx_data, PAYLOAD_WIDTH))
        {
            switch(rx_data[0])
            {
                case CMD_PAIR_CODE:
                   rf_pair_handle(rx_data);
                break;
                
                case CMD_CONTROL_CODE:
                   rf_data_parse();                                             //ݽֻжŻ
                break;
            }
        }
    }
}		

/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/




