//===================================================================================//
//  * @file           rf.h
//  * @author         liuhaibing
//  * @version        V1.0.0
//  * @date           2021/05/14
//  * @brief          4SPI,250K,CE,IRQ
//===================================================================================//
#ifndef   _RF_H_
#define   _RF_H_

#include "stm8l15x.h"
#include "stm8l15x_gpio.h"




////////////////////////////////////////////////////////////////////////////////
//                    Ϊ֣޸                              //
////////////////////////////////////////////////////////////////////////////////
/******************** ָĴ ********************/
#define		R_REGISTER			0x00                            //SPI read RF data
#define		W_REGISTER			0x20                            //SPI write RF data
#define		R_RX_PAYLOAD		        0x61                            //Read RX Payload
#define		W_TX_PAYLOAD		        0xA0                            //Write TX Payload
#define		FLUSH_TX			0xE1                            //Flush RX FIFO
#define		FLUSH_RX			0xE2                            //Flush TX FIFO
#define		REUSE_TX_PL			0xE3                            //Reuse TX Payload
#define		ACTIVATE			0x50                            //ACTIVATE
#define		DEACTIVATE			0x50                            //DEACTIVATE
#define		R_RX_PL_WID			0x60                            //Read width of RX data 
#define		W_ACK_PAYLOAD		        0xA8                            //Data with ACK
#define		W_TX_PAYLOAD_NOACK	        0xB0                            //TX Payload no ACK Request
#define		CE_FSPI_ON	                0xFD                            // CE HIGH
#define		CE_FSPI_OFF	                0xFC                            // CE LOW
#define		RST_FSPI	                0x53                            // RESET
#define		NOP_N				0xFF

            
/******************  ƼĴ *******************/
#define		CONFIG                          0x00            
#define		EN_AA				0x01
#define		EN_RXADDR			0x02
#define		SETUP_AW			0x03
#define		SETUP_RETR			0x04
#define		RF_CH				0x05
#define		RF_SETUP			0x06
#define		STATUS				0x07
#define		OBSERVE_TX			0x08
#define		RPD			        0x09
#define		RX_ADDR_P0			0x0A
#define		RX_ADDR_P1			0x0B
#define		RX_ADDR_P2			0x0C
#define		RX_ADDR_P3			0x0D
#define		RX_ADDR_P4			0x0E
#define		RX_ADDR_P5			0x0F
#define		TX_ADDR				0x10
#define		RX_PW_P0			0x11
#define		RX_PW_P1			0x12
#define		RX_PW_P2			0x13
#define		RX_PW_P3			0x14
#define		RX_PW_P4			0x15
#define		RX_PW_P5			0x16
#define		FIFO_STATUS			0x17
#define		DEM_CAL				0x19
#define         RF_CAL2				0x1A
#define         DEM_CAL2			0x1B
#define		DYNPD				0x1C
#define		FEATURE				0x1D	
#define		RF_CAL				0x1E
#define		BB_CAL				0x1F



/******************  ʵλ   *******************/
#define	XN297L_RF_POWER_P_11			0x27	// 11dbm								// 11dBm
#define	XN297L_RF_POWER_P_10			0x26	// 10dbm							// 10dBm
#define	XN297L_RF_POWER_P_9			0x15	// 9dbm								// 9dBm
#define	XN297L_RF_POWER_P_5			0x2c	// 5dbm								// 5dBm
#define	XN297L_RF_POWER_P_4			0x14	// 4dbm								// 4dBm
#define	XN297L_RF_POWER_N_1			0x2A	// -1dbm								// -1dBm
#define	XN297L_RF_POWER_N_9			0x29	// -9dbm								// -9dBm
#define	XN297L_RF_POWER_N_10			0x19	// -10dbm								// -10dBm
#define	XN297L_RF_POWER_N_23			0x30    // -23dbm



/****************  ״̬־   ********************/
#define         RX_DR_FLAG                      0X40                            // жϱ־λ
#define         TX_DS_FLAG                      0X20                            // жϱ־λ
#define         RX_TX_FLAG                      0X60                            // ͽжϱ־λack_payload ģʽʹ
#define         MAX_RT_FLAG                     0X10                            // شʱжϱ־λ


/****************     ********************/
#define         DR_250K                        0XC0				//ͨ 250Kbps


///////////////////////////////////////////////////////////////////////////////
//                  ûӦã²ֿҪ޸                       //
///////////////////////////////////////////////////////////////////////////////
/****************** ûԶ   **********************/
#define         DEFAULT_CHANNEL                78				//ʼʱƵʣ 2478 MHz (ʵƵΪ2400+DEFAULT_CHANNEL)         
#define         PAYLOAD_WIDTH                  8				//Payloadȣ     8bytes				
#define         DATA_RATE                      DR_250K                          //ͨ 250Kbps   
#define         RF_POWER                      (XN297L_RF_POWER_P_9 |DATA_RATE)	//书9dBm 


/******************** Control I/O *****************************/
#define         CSN_HIGH         GPIOB->ODR |= GPIO_Pin_4                       //set GPIOB Pin4 high
#define         CSN_LOW          GPIOB->ODR &= (~GPIO_Pin_4)                    //set GPIOB Pin4 low
#define         SCK_HIGH         GPIOB->ODR |= GPIO_Pin_5
#define         SCK_LOW          GPIOB->ODR &= (~GPIO_Pin_5)
#define         MOSI_HIGH        GPIOB->ODR |= GPIO_Pin_6;
#define         MOSI_LOW         GPIOB->ODR &= (~GPIO_Pin_6)
#define         MISO_STATUS      GPIO_ReadInputDataBit(GPIOB,GPIO_Pin_7)

#define        CE_HIGH           RF_WriteReg(CE_FSPI_ON, 0)
#define        CE_LOW            RF_WriteReg(CE_FSPI_OFF, 0)



/******************* Function declare *******************/

uint8_t 	SPI_RW( uint8_t	 R_REG);
uint8_t 	RF_ReadReg( uint8_t reg);
void 		RF_WriteReg( uint8_t reg,  uint8_t wdata);
void 		RF_ReadBuf( uint8_t reg,  uint8_t *pBuf,  uint8_t length);
void 		RF_WriteBuf( uint8_t reg,  uint8_t *pBuf,  uint8_t length);
uint8_t         RF_Init(void);                                                     
void 		RF_TxMode(void);
void	 	RF_RxMode(void);
uint8_t 	RF_GetStatus(void);
void 		RF_ClearStatus(void);
void 		RF_ClearFIFO(void);
void 		RF_SetChannel( uint8_t Channel);
void    	RF_TxData( uint8_t *ucPayload,  uint8_t length);
uint8_t 	RF_DumpRxData( uint8_t *ucPayload,  uint8_t length);
void 		RF_Carrier( uint8_t ucChannel_Set);
void            delay_100us(u16 n_100us);
void            delay_ms(u16 n_ms);
#endif

/****************************************end of file********************************************/

