//===================================================================================//
//  * @file           main.c
//  * @author         liuhaibing
//  * @version        V1.0.0
//  * @date           2021/05/14
//  * @brief          xn297l ˫ͨ
//===================================================================================//
/* Includes ------------------------------------------------------------------*/
#include "stm8l15x.h"
#include "rf.h"


/******************************************************************************/
//            IO_Port_Initial
//            Initial all gpio: set RESET_PIN to Output
/******************************************************************************/
void  IO_Init(void)
{
    //CLK_PeripheralClockConfig(CLK_Peripheral_TypeDef CLK_Peripheral, FunctionalState NewState);
    GPIO_DeInit(GPIOA);  
    GPIO_DeInit(GPIOB);   
    GPIO_DeInit(GPIOC);   
    GPIO_DeInit(GPIOD); 
}


void MCU_Init(void)
{
    __disable_interrupt();
    CLK_DeInit();
    CLK_HSICmd(ENABLE);
    CLK_SYSCLKDivConfig(CLK_SYSCLKDiv_1);
    CLK_ClockSecuritySystemEnable();
    __enable_interrupt();  
    
    IO_Init();
}

uint8_t tx_data[PAYLOAD_WIDTH]={0x12,0x34,0x56,0x78,0x12,0x34,0x56,0x78};
uint8_t rx_data[PAYLOAD_WIDTH]={0};
/******************************************************************************/
// @brief  mainMCUʼRFʼΪģʽ
// @param  None
// @retval None            
/******************************************************************************/
void main(void)
{  
   /****mcu init*********/ 
    MCU_Init();
   /*****rf init***********/    
    while(!RF_Init());
    RF_TxMode(); 
    while(1)
    {
        RF_TxData( tx_data,  PAYLOAD_WIDTH);
        //ɺлΪRX״̬
        RF_WriteReg(W_REGISTER + CONFIG,  0X8F ); 	
        delay_ms(5); //5msʱ
        RF_DumpRxData(rx_data, PAYLOAD_WIDTH);//鿴Ƿݽյ
        CE_LOW; //250KCEӦñֳߣRXתTXCEΪߣڲдTX FIFOоƬҲԶһ,ｫCE
        RF_WriteReg(W_REGISTER + CONFIG,  0X8E); //յݺлΪTX
        
        delay_ms(10);
    }
}		

/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/




