# <center >XN297L 主动跳频</center >

### 一、简介

本例程演示xn297l 主动跳频功能

​        TX端每10ms发射一次数据，数据长度为8bytes，前7bytes为应用数据，最后1bytes为跳频信息标记数据，分别为1，2，3循环。即TX端每一个发射周期为30ms，每个周期内发射三次数据，三次数据的序列号分别为1，2，3。每一个周期结束后切换一次频点。

​		RX端一直处于接收数据的状态，如果收到了发射周期中的序列号为1的数据包，则在25ms之后切换频点，如果收到了序列号为2的数据包，则在15ms之后切换频点，如果收到了序列号为3的数据包，则在5ms之后切换频点。如果在10ms（从上一次收到数据开始计时)内没有收到数据，数据以30ms（从上一次切换频点后开始计时)间隔跳频，同时如果在10ms内没有收到数据，丢包计数加一，当达到丢包最大数目后(比如10，接收超时为100ms)，RX开始以100ms的间隔跳频，直到再次同步。

### 二、条件说明

    SPI类型：4线spi
    RF速率：2M/1M(具体速率选择通过rf.h中宏定义DATA_RATE设置)
    CE模式:  软件CE
    数据长度：8bytes
    频点：2420Mhz、2440Mhz、2465Mhz
    功率：9dbm
### 三、接口(移植)实现

1、根据实际使用的MCU实现rf.c中延时函数delay_ms()和delay_100us();

2、根据实际使用情况修改rf.c中SPI_init函数

![spi_init](img\spi_init.png)

修改rf.h中RF相关IO口的定义。

<img src="img\io_set.png" alt="io_set" style="zoom:150%;" />

3、根据实际使用的MCU实现main.c中定时器相关操作，具体为实现一个1ms的定时器，以及定时器的中断处理。

### 四、应用范例

TX端：设置为发射模式， 10ms发送一次数据。发三次后切换一次频点。

![tx](img\tx.png)

RX端：上电设置为接收模式，接收到数据后根据包中序列号更新下一次需要跳频的时间点。

![rx](img\rx.png)

如果没收到数据包，则判断是否需要进行丢包计数或者跳频

![tx](img\rx_lost_handle.png)



### 五、参考文档

01_SDK\2M_1M\4_LINE_SPI\hopping\XN297L跳频参考.pdf

