# <center >XN297L 单向对码</center >

### 一、简介

本例程演示xn297l 单向对码功能，断电后对码状态重置（即每次上电都需重新对码），如需要保存对码状态，请参照《单向对码》文档自行实现。

### 二、条件说明

    SPI类型：4线spi
    RF速率：2M/1M(具体速率选择通过rf.h中宏定义DATA_RATE设置)
    CE模式:  软件CE
    数据长度：8bytes
    频点：2478Mhz
    功率：9dbm
### 三、接口(移植)实现

1、根据实际使用的MCU实现rf.c中延时函数delay_ms()和delay_100us();

2、根据实际使用情况修改rf.c中SPI_init函数

![spi_init](img\spi_init.png)

修改rf.h中RF相关IO口的定义。

<img src="img\io_set.png" alt="io_set" style="zoom:150%;" />

### 四、应用范例

TX端：设置为发射模式， 首先读取滚码作为自己ID，初始化为对码模式。在主循环中可以通过按键切换发射“对码包”和对码完成之后的“控制包”  ，demo演示的是以间隔10ms的频率持续发射数据，实际应用中请按照实际要求实现。比如上电后先不发射数据，按“对码键”后开始发射对码包。

![tx](img\tx.png)

RX端：上电设置为接收模式，并且先进入配对模式，接收到数据后判断是“对码包”还是“控制包”，并进行相应处理。

![rx](img\rx.png)

在收到“对码包”之后，将接收数据中的“ID”设置新的接收地址，从而达到只能被拥有唯一“ID”的发射端控制。

![rx](img\rx_addr_update.png)

在本例程中，由于我们每次配对的状态不保存，所以我们接收只需要用到通道0（RX_ADDR_P0）就可以了，对码未完成之前通道0设置公共地址，对码完成后更新为专用地址。如果我们需要做配对状态保存，更方便的做法是接收使用两个通道，即RX_ADDR_P0和RX_ADDR_P1。RX_ADDR_P0设置为公共地址，RX_ADDR_P1设置为上次对码的专用地址。在接收到数据后我们可以通过读取status寄存器(RF_ReadReg(STATUS))中的bit<3:1>来判断是哪个通道收到数据，进而判断出是对码通道收到数据还是控制通道收到数据，当然也可以在数据包中加入相应标志位来判断。

### 五、参考文档

01_SDK\2M_1M\4_LINE_SPI\pair\单向对码.pdf

