//===================================================================================//
//  * @file           RF.c
//  * @author         liuhaibing
//  * @version        V1.2
//  * @date           2021/05/22
//  * @brief          Main program body
//===================================================================================//
#include "RF.H"


uint8_t TX_ADDRESS_DEF[5] = {0xCC,0xCC,0xCC,0xCC,0xCC};


uint8_t TxPayloadLength = PAYLOAD_WIDTH;
const uint8_t AckPayloadLength = 0x00;
uint32_t Payload_Count = 0;
uint16_t tx_only_count=0;
uint16_t  time_out_count=0;


/******************************************************************************/
// !!!!!!!!!!!!!!!!!!!!òҪ޸!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

// @brief  ʵ1msʱ,òҪûԼʵʹõMCU޸
// @param  n_msҪʱʱ䣬λΪms 
// @retval None             
/******************************************************************************/
void delay_ms(u16 n_ms)
{
   uint16_t i,j;
   for(i=0;i<n_ms;i++)
   {
       for(j=0;j<2300;j++)
       {
           nop();
       }
   }
}

/******************************************************************************/
// !!!!!!!!!!!!!!!!!!!!òҪ޸!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

// @brief  ʵ100usʱ,òҪûԼʵʹõMCU޸
// @param  n_100usҪʱʱ䣬λΪ100us 
// @retval  None             
/******************************************************************************/
void delay_100us(u16 n_100us)
{
   uint16_t i,j;
   for(i=0;i<n_100us;i++)
   {
       for(j=0;j<225;j++)
       {
           nop();
       }
   }

}


#if( SPI_MODE ==  SPI_4_LINE_MODE ) 
/******************************************************************************/
// !!!!!!!!!!!!!!!!!!!!òҪ޸!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

// @brief  ʼSPI,òҪûԼʵʹõMCUʵ(ǷʹõIRQ,CEŵ)޸
// @param  None 
// @retval  None             
/******************************************************************************/
    void SPI_init(void)
    { 
        GPIO_Init( GPIOD, GPIO_Pin_0, GPIO_Mode_In_PU_No_IT);                       //IRQ  input pulling high without interrupt
        GPIO_Init( GPIOB, GPIO_Pin_1, GPIO_Mode_Out_PP_Low_Fast);                   //CE   output Low pulling push
      
        GPIO_Init( GPIOB, GPIO_Pin_4, GPIO_Mode_Out_PP_High_Fast);                  //CSN  output High pulling push
        GPIO_Init( GPIOB, GPIO_Pin_5, GPIO_Mode_Out_PP_Low_Fast);                   //SCK  output Low  pulling push 
        GPIO_Init( GPIOB, GPIO_Pin_6, GPIO_Mode_Out_PP_High_Fast);                  //MOSI output High pulling push
        GPIO_Init( GPIOB, GPIO_Pin_7, GPIO_Mode_In_PU_No_IT);                       //MISO input pull high
    }

    /******************************************************************************/
    // @brief  SPIдһBYTEͬʱһBYTE
    // @param  R_REGSPIдֵ
    // @retval SPIֵ            
    /******************************************************************************/
     uint8_t SPI_RW( uint8_t R_REG)
     {
        uint8_t	  i;
        for(i = 0; i < 8; i++)
        {
            SCK_LOW;
            if(R_REG & 0x80)
            {
                MOSI_HIGH;
            }
            else
            {
                MOSI_LOW;
            }
            R_REG = R_REG << 1;
            SCK_HIGH;
            if( MISO_STATUS )
            {
              R_REG = R_REG | 0x01;
            }
        }
        SCK_LOW;
        return R_REG;
     }
        
        
    /******************************************************************************/
    // @brief  RFĴ
    // @param  regдW_REGISTER+Ĵַ(CONFIGΪ0x00)
    //         wdataҪΪĴõֵ  
    // @retval None            
    /******************************************************************************/
    void RF_WriteReg( uint8_t reg,  uint8_t wdata)
    {
        CSN_LOW;
        SPI_RW(reg);
        SPI_RW(wdata);
        CSN_HIGH;
    }

    /******************************************************************************/
    // @brief  RFĴȡ
    // @param  regR_REGISTER+Ĵַ(CONFIGΪ0x00) 
    // @retval ȡļĴֵ            
    /******************************************************************************/
     uint8_t RF_ReadReg( uint8_t reg)
    {
        uint8_t tmp;
        
        CSN_LOW;
        SPI_RW(reg);
        tmp = SPI_RW(0);
        CSN_HIGH;
        
        return tmp;
    }

    /******************************************************************************/
    // @brief  RFĴ
    // @param  regдW_REGISTER+Ĵַ
    //         pBufдݵʼַ
    //         length: дݵĳ 
    // @retval None           
    /******************************************************************************/
    void RF_WriteBuf( uint8_t reg, uint8_t *pBuf, uint8_t length)
    {
         uint8_t j;
        CSN_LOW;
        j = 0;
        SPI_RW(reg);
        for(j = 0;j < length; j++)
        {
            SPI_RW(pBuf[j]);
        }
        j = 0;
        CSN_HIGH;
    }

    /******************************************************************************/
    // @brief  RFĴȡ
    // @param  regR_REGISTER+Ĵַ
    //         pBufȡݴŵʼַ
    //         length: дȡݵĳ 
    // @retval None 
    /******************************************************************************/
    void RF_ReadBuf( uint8_t reg, uint8_t *pBuf,  uint8_t length)
    {
        uint8_t byte_ctr;

        CSN_LOW;                    		                               			
        SPI_RW(reg);       		                                                		
        for(byte_ctr=0;byte_ctr<length;byte_ctr++)
            pBuf[byte_ctr] = SPI_RW(0);                                                 		
        CSN_HIGH;                                                                   		
    }
#elif( SPI_MODE ==  SPI_3_LINE_MODE )
    /******************************************************************************/
    // !!!!!!!!!!!!!!!!!!!!òҪ޸!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    // @brief  ʼSPI,òҪûԼʵʹõMCU޸
    // @param  None 
    // @retval  None             
    /******************************************************************************/
    void SPI_init(void)
    {
        GPIO_Init( GPIOB, GPIO_Pin_4, GPIO_Mode_Out_PP_High_Fast);                  //CSN  output pulling push
        GPIO_Init( GPIOB, GPIO_Pin_5, GPIO_Mode_Out_PP_Low_Fast);                   //SCK  output pulling push  
        GPIO_Init( GPIOB, GPIO_Pin_6, GPIO_Mode_Out_PP_Low_Fast);                   //SPI DATA  output pulling push 
    }

    /******************************************************************************/
    // @brief  SPIдһBYTE
    // @param  R_REGSPIдֵ
    // @retval None         
    /******************************************************************************/
    void SPI_WR(unsigned char R_REG)
    {
        unsigned char  i;
        SPI_DATA_OUTPUT;
        for(i = 0; i < 8; i++)
        {
                SCK_LOW;
                if(R_REG & 0x80)
                {
                        SPI_DATA_HIGH;
                }
                else
                {
                        SPI_DATA_LOW;
                }
                R_REG = R_REG << 1;
                SCK_HIGH;	
        }
         SPI_DATA_HIGH;
        SCK_LOW;
    }


    /******************************************************************************/
    // @brief  SPI֮ǰдҪַ
    // @param  R_REGSPIдֵ
    // @retval None         
    /******************************************************************************/
    void SPI_WR_forRD(unsigned char R_REG)
    {
        unsigned char  i;
                SPI_DATA_OUTPUT;
        for(i = 0; i < 8; i++)
        {
                SCK_LOW;
                if(R_REG & 0x80)
                {
                        SPI_DATA_HIGH;
                }
                else
                {
                        SPI_DATA_LOW;
                }
                R_REG = R_REG << 1;
                SCK_HIGH;
        }
        
        //SPI_DATA_HIGH;
        SPI_DATA_INPUT;
        SCK_LOW;
    }


    /******************************************************************************/
    // @brief  SPIһBYTE
    // @param  None
    // @retval SPIֵ        
    /******************************************************************************/
    /******************************************************************************/
    uint8_t  SPI_RD(void)
    {
        uint8_t   i,data;
        
        data = 0;
        for(i = 0; i < 8; i++)
        {
                SCK_LOW;
                data = data << 1;
                SCK_HIGH;
                if(SPI_DATA_STATUS)
                {
                  data |= 0x01;
                }
        }
        SCK_LOW;

        return data;
    }

    /******************************************************************************/
    // @brief  RFĴ
    // @param  regдW_REGISTER+Ĵַ(CONFIGΪ0x00)
    //         wdataҪΪĴõֵ  
    // @retval None            
    /******************************************************************************/
    void RF_WriteReg( uint8_t reg,  uint8_t wdata)
    {
        CSN_LOW;
        SPI_WR(reg);
        SPI_WR(wdata);
        CSN_HIGH;
    }

    /******************************************************************************/
    // @brief  RFĴȡ
    // @param  regR_REGISTER+Ĵַ(CONFIGΪ0x00) 
    // @retval ȡļĴֵ            
    /******************************************************************************/
    uint8_t RF_ReadReg( uint8_t reg)
    {
        uint8_t tmp;
        
        CSN_LOW;
        SPI_WR_forRD(reg);
        tmp = SPI_RD();
        CSN_HIGH;
        
        return tmp;
    }

    /******************************************************************************/
    // @brief  RFĴ
    // @param  regдW_REGISTER+Ĵַ
    //         pBufдݵʼַ
    //         length: дݵĳ 
    // @retval None           
    /******************************************************************************/
    void RF_WriteBuf( uint8_t reg, uint8_t *pBuf, uint8_t length)
    {
        uint8_t j;
        CSN_LOW;
        j = 0;
        SPI_WR(reg);
        for(j = 0;j < length; j++)
        {
                SPI_WR(pBuf[j]);
        }
        j = 0;
        CSN_HIGH;
    }


    /******************************************************************************/
    // @brief  RFĴȡ
    // @param  regR_REGISTER+Ĵַ
    //         pBufȡݴŵʼַ
    //         length: дȡݵĳ 
    // @retval None 
    /******************************************************************************/
    void RF_ReadBuf( uint8_t reg, unsigned char *pBuf,  uint8_t length)
    {
        uint8_t byte_ctr;

        CSN_LOW;                    		                               			
        SPI_WR_forRD(reg);       		                                                		
        for(byte_ctr=0;byte_ctr<length;byte_ctr++)
                pBuf[byte_ctr] = SPI_RD();                                                 		
        CSN_HIGH;                                                                   		
    }  
#endif



/******************************************************************************/
// @brief  RFΪTX mode
// @param  None
// @retval None 
/******************************************************************************/
void RF_TxMode(void)
{
    
    RF_WriteReg(W_REGISTER + CONFIG,  0X8E);					
    delay_ms(10);   
    CE_HIGH;	
    delay_ms(10);
}


/******************************************************************************/
// @brief  RFΪRX mode
// @param  None
// @retval None 
/******************************************************************************/
void RF_RxMode(void)
{
    RF_WriteReg(W_REGISTER + CONFIG,  0X8F );					  			                                       
    delay_ms(10);   
    CE_HIGH;	
    delay_ms(10);
}

/******************************************************************************/
// @brief  ȡRF״̬־
// @param  None
// @retval ״ֵ̬
//         bit6յݱ־ 
//         bit5ɹ־ 
//         bit4䳬ʱ־ 
//         bit3-1:ȡݺжĸͨգ˴ò
//         bit0: TX FIFO״̬־˴ò     
/******************************************************************************/
uint8_t RF_GetStatus(void)
{
    return RF_ReadReg(STATUS)&0x70;						
}


/******************************************************************************/
// @brief  RF״̬־
// @param  None
// @retval None 
/******************************************************************************/
void RF_ClearStatus(void)
{
    RF_WriteReg(W_REGISTER + STATUS,0x70);							
}

/******************************************************************************/
// @brief  RF FIFO,ɸʵTX_FIFORX_FIFO
// @param  None
// @retval None 
/******************************************************************************/
void RF_ClearFIFO(void)
{
    RF_WriteReg(FLUSH_TX, 0);	//RF  TX FIFO		
    RF_WriteReg(FLUSH_RX, 0);   //RF  RX FIFO	
}

/******************************************************************************/
// @brief  RFƵ
// @param  ChannelõƵΪ2400+ChannelMHz
// @retval None 
/******************************************************************************/
void RF_SetChannel( uint8_t Channel)
{    
    RF_WriteReg(W_REGISTER + RF_CH, Channel);
}

// @brief  RF
// @param  ucPayloadݵʼַ
//         lengthݳ     
// @retval None 
/******************************************************************************/
void RF_TxData( uint8_t *ucPayload,  uint8_t length)
{
    RF_WriteBuf(W_TX_PAYLOAD, ucPayload, length);                                                                  		//rf entery tx mode start send data                                                                       		//rf entery stb3
    delay_ms(2);  
   
    while(!(RF_GetStatus())) //ֱκһ־λ
    {
        delay_ms(1);  
    }
    
}



/******************************************************************************/
// @brief  RF
// @param  ucPayloadݴŵʼַ
//         lengthݳ     
// @retval 1յ
//         0: ûյ              
/******************************************************************************/
uint8_t RF_DumpRxData( uint8_t *ucPayload,  uint8_t length)
{ 
 
    if(!(RF_GetStatus()&RX_DR_FLAG))
    {
      return 0;                                                                 		
    }

    RF_ReadBuf(R_RX_PAYLOAD, ucPayload, length);                                //յݶucPayload
 
    return 1;
}

/******************************************************************************/
// @brief  ˲ѯͽ
// @param  ucAckPayloadյն˻ظack paylaodȡõַ
//         lengthȡݳ   
// @retval None 
/******************************************************************************/
void RF_TX_CheckResult(uint8_t *ucAckPayload, uint8_t length)
{
  switch(RF_GetStatus())
  {
      case TX_DS_FLAG: 
             tx_only_count++;
             RF_ClearFIFO();
             RF_ClearStatus();
             break;
               
      case RX_TX_FLAG:
             RF_ReadBuf(R_RX_PAYLOAD,ucAckPayload,length);
             ++Payload_Count;
             RF_ClearFIFO();
             RF_ClearStatus();
             break;
        
      case MAX_RT_FLAG:
             time_out_count++;
             RF_ClearFIFO();
             RF_ClearStatus();
             break;
      default:
            RF_ClearFIFO();
            RF_ClearStatus();
            break;
  }
}

/******************************************************************************/
// @brief  RFʼ
// @param  None
// @retval 1ʼɹ
//         0: ʼʧ             
/******************************************************************************/
uint8_t RF_Init(void)
{
    #if(DATA_RATE == DR_1M || DATA_RATE == DR_2M ) 
       uint8_t BB_cal_data[]	= {0x12,0xED,0x67,0x9C,0x46};
       uint8_t RF_cal_data[]	= {0xF6,0x3F,0x5D};
       #if( CE_MODE ==  CE_MODE_HARD )   
          uint8_t RF_cal2_data[] = {0x45,0x21,0xEF,0x2C,0x5A,0x40};
       #elif( CE_MODE ==  CE_MODE_SOFT )
          uint8_t RF_cal2_data[] = {0x45,0x21,0xEF,0x2C,0x5A,0x42};
       #endif
       uint8_t Dem_cal_data[]	= {0x01};
       uint8_t Dem_cal2_data[]	= {0x0B,0xDF,0x02};   
    #elif(DATA_RATE == DR_250K) 
       uint8_t BB_cal_data[]	= {0x12,0xEC,0x6F,0xA1,0x46};
       uint8_t RF_cal_data[]	= {0xF6,0x3F,0x5D};
       #if( CE_MODE ==  CE_MODE_HARD )   
          uint8_t RF_cal2_data[] = {0xD5,0x21,0xEB,0x2C,0x5A,0x40};
       #elif( CE_MODE ==  CE_MODE_SOFT )
          uint8_t RF_cal2_data[] = {0xD5,0x21,0xEB,0x2C,0x5A,0x42};
       #endif
       uint8_t Dem_cal_data[]	= {0x1F};
       uint8_t Dem_cal2_data[]	= {0x0B,0xDF,0x02}; 
    #endif
       
    #if( CE_MODE ==  CE_MODE_HARD )   
       uint8_t feature = 0x00;
    #elif( CE_MODE ==  CE_MODE_SOFT )
       uint8_t feature = 0x20;
    #endif
    
    #if( SPI_MODE ==  SPI_4_LINE_MODE) 
       SPI_init();
    #elif( SPI_MODE ==  SPI_3_LINE_MODE)
       delay_ms(200);
       SPI_init();
       delay_ms(2);
    #endif
                    
    RF_WriteReg(RST_FSPI, 0x5A);								//Software Reset    			
    RF_WriteReg(RST_FSPI, 0XA5);
    
    RF_WriteReg(FLUSH_TX, 0);									// CLEAR TXFIFO		    			 
    RF_WriteReg(FLUSH_RX, 0);									// CLEAR  RXFIFO
    RF_WriteReg(W_REGISTER + STATUS, 0x70);							// CLEAR  STATUS	
    RF_WriteReg(W_REGISTER + EN_RXADDR, 0x01);							// Enable Pipe0
    RF_WriteReg(W_REGISTER + SETUP_AW,  0x03);							// address witdth is 5 bytes
    RF_WriteReg(W_REGISTER + RF_CH,     DEFAULT_CHANNEL);                                       // 2478M HZ
    RF_WriteReg(W_REGISTER + RX_PW_P0, PAYLOAD_WIDTH );						// 8 bytes
    RF_WriteBuf(W_REGISTER + TX_ADDR,  TX_ADDRESS_DEF, sizeof(TX_ADDRESS_DEF));	                // Writes TX_Address to XN297L
    RF_WriteBuf(W_REGISTER + RX_ADDR_P0,TX_ADDRESS_DEF, sizeof(TX_ADDRESS_DEF));	        // RX_Addr0 same as TX_Adr for Auto.Ack  
  
    RF_WriteBuf(W_REGISTER + BB_CAL,    BB_cal_data,  sizeof(BB_cal_data));
    RF_WriteBuf(W_REGISTER + RF_CAL2,   RF_cal2_data, sizeof(RF_cal2_data));
    RF_WriteBuf(W_REGISTER + DEM_CAL,   Dem_cal_data, sizeof(Dem_cal_data));
    RF_WriteBuf(W_REGISTER + RF_CAL,    RF_cal_data,  sizeof(RF_cal_data));
    RF_WriteBuf(W_REGISTER + DEM_CAL2,  Dem_cal2_data,sizeof(Dem_cal2_data));
    RF_WriteReg(W_REGISTER + DYNPD, 0x00);					                            
    RF_WriteReg(W_REGISTER + RF_SETUP,  RF_POWER);						// 9dbm  1Mbps 		
    RF_WriteReg(ACTIVATE, 0x73);
    
#if(TRANSMIT_TYPE == TRANS_ENHANCE_MODE)      
    RF_WriteReg(W_REGISTER + SETUP_RETR,0x01);							//  1 retrans... 	
    RF_WriteReg(W_REGISTER + EN_AA,     0x01);							// Enable Auto.Ack:Pipe0  	
#elif(TRANSMIT_TYPE == TRANS_BURST_MODE)                                                                
    RF_WriteReg(W_REGISTER + SETUP_RETR,0x00);							// Disable retrans... 	
    RF_WriteReg(W_REGISTER + EN_AA,     0x00);							// Disable AutoAck 
#endif

#if(EN_DYNPLOAD == 1)
    feature |= 0x04;
    RF_WriteReg(W_REGISTER + DYNPD, 0x01); //̬ʹpipe0̬ 
#endif

#if(EN_ACK_PAYLOAD == 1)
    feature |= 0x02;  
#endif

if(PAYLOAD_WIDTH >32)
    feature |= 0x18;

    RF_WriteReg(W_REGISTER + FEATURE, feature);
    
    if(RF_ReadReg(RF_CH)!=DEFAULT_CHANNEL)
      return 0;
    return 1;

}

/******************************************************************************/
//            		زģʽ
/******************************************************************************/
void RF_Carrier( uint8_t ucChannel_Set)
{
    uint8_t BB_cal_data[]	= {0x12,0xED,0x67,0x9C,0x46};
    uint8_t RF_cal_data[]	= {0xF6,0x3F,0x5D};
#if( CE_MODE ==  CE_MODE_HARD )   
    uint8_t RF_cal2_data[]	= {0x45,0x21,0xEF,0x2C,0x5A,0x40};
#elif( CE_MODE ==  CE_MODE_SOFT )
    uint8_t RF_cal2_data[]	= {0x45,0x21,0xEF,0x2C,0x5A,0x42};
#endif
    uint8_t Dem_cal_data[]	= {0xE1};
    uint8_t Dem_cal2_data[]	= {0x0B,0xDF,0x02};     

    RF_WriteReg(RST_FSPI, 0x5A);						//Software Reset    			
    RF_WriteReg(RST_FSPI, 0XA5);
    
    #if( CE_MODE ==  CE_MODE_HARD )   
       uint8_t feature = 0x00;
    #elif( CE_MODE ==  CE_MODE_SOFT )
       uint8_t feature = 0x20;
    #endif
 
    RF_WriteReg(W_REGISTER + FEATURE, feature);
    
    CE_LOW;
    delay_100us(5);				 						//delay 500us
    RF_WriteReg(W_REGISTER + CONFIG, 0X8E);        						//tx mode 
    RF_WriteReg(W_REGISTER + RF_CH, ucChannel_Set);						//زƵ	   
    RF_WriteReg(W_REGISTER + RF_SETUP, RF_POWER);      						//9dbm
    RF_WriteBuf(W_REGISTER + BB_CAL,    BB_cal_data,  sizeof(BB_cal_data));
    RF_WriteBuf(W_REGISTER + RF_CAL2,   RF_cal2_data, sizeof(RF_cal2_data));
    RF_WriteBuf(W_REGISTER + DEM_CAL,   Dem_cal_data, sizeof(Dem_cal_data));
    RF_WriteBuf(W_REGISTER + RF_CAL,    RF_cal_data,  sizeof(RF_cal_data));
    RF_WriteBuf(W_REGISTER + DEM_CAL2,  Dem_cal2_data,sizeof(Dem_cal2_data));
    delay_100us(5);	
}

/***************************************end of file ************************************/
