//===================================================================================//
//  * @file           RFAPI.c
//  * @author         Shi Zheng
//  * @version        V1.1
//  * @date           Aug/12/2013
//  * @brief          Main program body
//  * @modify user:   liuhaibing
//  * @modify date:   2019/12/19
//===================================================================================//
/* Includes ------------------------------------------------------------------*/


#include "stm8l15x.h"
#include "App.h"
#include "APPSub.h"
#include "LED.h"
#include "Key.h"
#include "stdio.h"

bool  bRFAPI_IRQ = FALSE;
bool  flag_flush=TRUE;
enum  RFAPI_CommuSate  ucRFAPI_STATE;
RF_PAYLOAD  RF_Payload;
uint8_t Channel_Index=19;  //2478
uint8_t const CHANNEL_TABLE[] = {2,6,10,14,18,22,26,30,34,38,42,46,50,54,58,62,66,70,74,78};
uint8_t const CHANNEL_TABLE_CARRIER[] = {2,50,78};

#if(EN_DYNPLOAD == 1)
  uint8_t PayLoadLength=0;
#endif

#if(EN_ACK_PAYLOAD == 1)
uint8_t  PayLoadAck_Data[PAYLOAD_WIDTH]={0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
#endif

/******************************************************************************/
//            RF_Channel_Next
//                Hop to next channel
/******************************************************************************/
void RFAPI_ChannelNext(void)
{
   
  if((Channel_Index == 0)||(Channel_Index >= sizeof(CHANNEL_TABLE)))
  {
      Channel_Index = sizeof(CHANNEL_TABLE)-1;
  }
  else
  {
      Channel_Index--;
  }
    
  RF_SetChannel(CHANNEL_TABLE[Channel_Index] );
}


/******************************************************************************/
//            RF_PacketData
//                packet tx data
/******************************************************************************/
void RFAPI_PacketData(void)
{
    RF_Payload.ucPayload[0] = 0x12;
    RF_Payload.ucPayload[1] = 0x23;
    RF_Payload.ucPayload[2] = 0x34;
    RF_Payload.ucPayload[3] = 0x45;
    RF_Payload.ucPayload[4] = 0x56;
    RF_Payload.ucPayload[5] = 0x67;
    RF_Payload.ucPayload[6] = 0x78;
    RF_Payload.ucPayload[7] = 0x86;
}


/******************************************************************************/
//            RFAPI_TxState
//                In IRFAPI_TxState ,Data will be write into RF if TX enabled
/******************************************************************************/
void RFAPI_TxState(void)
{
    if(!(TX_RQ))                                                               //if don't need to  transmit data
    {
        return;      
    }
    TX_RQ = FALSE; 
    
    RFAPI_PacketData();                                                        //prepare data
   
    RF_TxData(RF_Payload.ucPayload,TxPayloadLength);
    RF_TX_CheckResult(RF_Payload.ucPayload, PAYLOAD_WIDTH);
}


/******************************************************************************/
//            BB_RX_State
//                In RX status ,Judge data has been received and read them
/******************************************************************************/
void  RFAPI_RXState(bool RX_Continue)
{
    if(RF_DumpRxData(RF_Payload.ucPayload,PAYLOAD_WIDTH))
    {

#if(EN_ACK_PAYLOAD ==1)
        RF_WriteBuf(W_ACK_PAYLOAD, PayLoadAck_Data, ACK_PAYLOAD_WIDTH); 
        delay_ms(2);
#endif
        RF_ClearFIFO();
        RF_ClearStatus();
        ucRFAPI_STATE = RFAPI_RX;
        RX_READY = TRUE;

    }
}


/******************************************************************************/
//            Test_Mode
//                Set RF into TestMode
/******************************************************************************/
void RFAPI_TestMode(void)
{
         
    if(ucTest_Mode == 0) // TEST_DEFAULT_MODE = 0, Ĭģʽ
    {

        return;                                                                 //normal mode
    }
    else if(ucTest_Mode == TEST_CARRIER_MODE)
    {
             RF_Carrier(DEFAULT_CHANNEL);   
             LED_ChangeFont(DEFAULT_CHANNEL,LED_FUNCTION_MODE);   

         while(1)
        {    
             Key_Scan(); 
            if(DATA_READY)                                                                //if Key Event
            {
              DATA_READY = FALSE;
             if(ucKey_RD == KEY3)                                                        //if press Key1 button down
                {
                if((Channel_Index == 0)||(Channel_Index >= sizeof(CHANNEL_TABLE_CARRIER)))
                  {
                  Channel_Index = sizeof(CHANNEL_TABLE_CARRIER)-1;
                  }
                 else
                  {
                   Channel_Index--;
                   }
                       
               RF_Carrier( CHANNEL_TABLE_CARRIER[Channel_Index]);                                //set RF into carry mode
               LED_ChangeFont(CHANNEL_TABLE_CARRIER[Channel_Index],LED_FUNCTION_MODE);   
                }                                                  
                                                     
              }
              LED_Display(); 
          }
    
    }else
      {
        ucTest_Mode = 0;                                                        //normal mode
    
      }
}


/******************************************************************************/
//            BB_StateMachine
//                BB TX/RX Work StateMachine
/******************************************************************************/
void RFAPI_StateMachine(void)
{
    switch(ucRFAPI_STATE)
    {
      case RFAPI_TX:                                                             //RF in Idle
          RFAPI_TxState();
          break;
      case  RFAPI_RX:                                                              //RF in RX
          RFAPI_RXState(TRUE);
          break;
      case  RFAPI_HALT:                                                            //RF in shutdown
          break;
      default:
          break;
    }
}

//********************************end of file*********************************//