//===================================================================================//
//  * @file           main.c
//  * @author         liuhaibing
//  * @version        V1.0.3
//  * @date           2021/08/13
//  * @brief          xn297l Ƶ(ǿģʽ)
//===================================================================================//
/* Includes ------------------------------------------------------------------*/
#include "stm8l15x.h"
#include "rf.h"
#include "stm8l15x_tim2.h"      

#define HOP_NUM    3
#define LOST_MAX_VALUE    HOP_NUM-1    
#define REV_INTERVAL_NORMAL  10 //δյݣ10msƵлƵ
#define REV_INTERVAL_SCAN    30 //ﵽLOST_MAX_VALUE30msƵлƵ


uint16_t timer_cnt=0;
uint8_t rev_interval=REV_INTERVAL_NORMAL;  
uint8_t flag_rev_out_time=0;
uint8_t hop_index=0;
uint8_t hop_table[HOP_NUM]={20,40,65};
uint16_t lost_cnt=0;

/******************************************************************************/
//            IO_Port_Initial
//            Initial all gpio: set RESET_PIN to Output
/******************************************************************************/
void  IO_Init(void)
{
    //CLK_PeripheralClockConfig(CLK_Peripheral_TypeDef CLK_Peripheral, FunctionalState NewState);
    GPIO_DeInit(GPIOA);  
    GPIO_DeInit(GPIOB);   
    GPIO_DeInit(GPIOC);   
    GPIO_DeInit(GPIOD); 
}

/******************************************************************************/
//            Timer_Iniital
//            Initial all timers: 
//                Timer2: 1ms AutoReload with Interrupt
/******************************************************************************/
void Timer_Init(void)
{
    CLK_PeripheralClockConfig(CLK_Peripheral_TIM2, ENABLE);  
    TIM2_Cmd(DISABLE);
    TIM2_DeInit();
    TIM2_TimeBaseInit(TIM2_Prescaler_16, TIM2_CounterMode_Up, 1000);
    TIM2_ARRPreloadConfig(ENABLE);
    TIM2_ClearFlag(TIM2_FLAG_Update);
    TIM2_ITConfig(TIM2_IT_Update, ENABLE);
    TIM2_SetCounter(0);
    
    TIM2_Cmd(ENABLE);
}

/**
  * @brief TIM2 Update/Overflow/Trigger/Break Interrupt routine.
  * @par Parameters:
  * None
  * @retval 
  * None
  */
INTERRUPT_HANDLER(TIM2_UPD_OVF_TRG_BRK_IRQHandler,19)
{
    TIM2_ClearITPendingBit(TIM2_IT_Update);
    timer_cnt++;
    if(timer_cnt>=rev_interval)
    {
       timer_cnt=0;
       flag_rev_out_time=1;    
    }
}


void MCU_Init(void)
{
    __disable_interrupt();
    CLK_DeInit();
    CLK_HSICmd(ENABLE);
    CLK_SYSCLKDivConfig(CLK_SYSCLKDiv_1);
    CLK_ClockSecuritySystemEnable();
    __enable_interrupt();  
    
    IO_Init();
    Timer_Init();
}

uint8_t rx_data[PAYLOAD_WIDTH]={0};
uint8_t ack_data[ACK_PAYLOAD_WIDTH]={0xAA,0xBB,0xCC,0xDD,0x12,0x34,0x56,0x78};




void rf_rev_status_reset(void)
{
   //յݰ0ճʱΪREV_INTERVAL_NORMAL 
    lost_cnt=0;
    timer_cnt=0;
    flag_rev_out_time=0;
    TIM2_SetCounter(0);
    rev_interval=REV_INTERVAL_NORMAL;
}

void rf_rev_data_handle(uint8_t * rev_data)
{
    
}


/******************************************************************************/
// @brief  mainMCUʼRFʼΪģʽ
// @param  None
// @retval None            
/******************************************************************************/
void main(void)
{  
   /****mcu init*********/ 
    MCU_Init();
   /*****rf init***********/    
    while(!RF_Init());
    RF_RxMode(); 
  
    while(1)
    {
        if(RF_DumpRxData(rx_data, PAYLOAD_WIDTH))
        {
            delay_ms(1);     //Ԥطackʱ
            rf_rev_status_reset();
            rf_rev_data_handle(rx_data); //ݴ
            RF_ClearFIFO();
            RF_ClearStatus();   
        }
        else
        {
               if(flag_rev_out_time) //յлƵ
               {
                   flag_rev_out_time=0;
                    hop_index++;
                    if(hop_index>2)
                      hop_index=0;
                    RF_SetChannel(hop_table[hop_index]);  
                    
                    lost_cnt++;  //
                    if(lost_cnt>=LOST_MAX_VALUE)
                    {
                        rev_interval=REV_INTERVAL_SCAN;
                    }
               }
        }
        
    }
}		

/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/




