//===================================================================================//
//  * @file           main.c
//  * @author         liuhaibing
//  * @version        V1.0.4
//  * @date           2021/11/29
//  * @brief          xn297l rssi ȡ
//===================================================================================//
/* Includes ------------------------------------------------------------------*/
#include "stm8l15x.h"
#include "rf.h"

#define CHANNEL_NUM 84

typedef struct RSSI_DATA
{
  uint8_t rssi_high_4bit[CHANNEL_NUM]; //4bitʾźǰǿ
  uint8_t rssi_low_4bit[CHANNEL_NUM];  //4bitʾݵźǿ
}RSSI_DATA_T;

RSSI_DATA_T rssi_data;


uint8_t rx_data[PAYLOAD_WIDTH]={0};

/******************************************************************************/
//            IO_Port_Initial
//            Initial all gpio: set RESET_PIN to Output
/******************************************************************************/
void  IO_Init(void)
{
    //CLK_PeripheralClockConfig(CLK_Peripheral_TypeDef CLK_Peripheral, FunctionalState NewState);
    GPIO_DeInit(GPIOA);  
    GPIO_DeInit(GPIOB);   
    GPIO_DeInit(GPIOC);   
    GPIO_DeInit(GPIOD); 
}


void MCU_Init(void)
{
    __disable_interrupt();
    CLK_DeInit();
    CLK_HSICmd(ENABLE);
    CLK_SYSCLKDivConfig(CLK_SYSCLKDiv_1);
    CLK_ClockSecuritySystemEnable();
    __enable_interrupt();  
    
    IO_Init();
}


void noise_discovery(void)
{
   for(uint8_t i=0;i<CHANNEL_NUM;i++)
   {
      RF_SetChannel(i);
      delay_100us(5);    
      rssi_data.rssi_high_4bit[i] =((RF_ReadReg(RPD)&0xf0)>>4);	                //ȡⲿźǿ
   }
}

/******************************************************************************/
// @brief  mainMCUʼRFʼΪģʽ
// @param  None
// @retval None            
/******************************************************************************/
void main(void)
{  
   /****mcu init*********/ 
    MCU_Init();
   /*****rf init***********/    
    while(!RF_Init());
    RF_RxMode(); 
    
    noise_discovery();                                                          //ȡֵ
    RF_SetChannel(DEFAULT_CHANNEL);                                             //Ƶ
    
    while(1)
    {     
         if(RF_DumpRxData(rx_data, PAYLOAD_WIDTH))
         {
             rssi_data.rssi_low_4bit[DEFAULT_CHANNEL] =(RF_ReadReg(RPD)&0x0f);  //ȡźŵǿ(յݺ100msڶ)
         }   
    }
}		






