# <center >TX-RX切换</center >

### 一、简介

本例程演示通过切换xn297l TX/RX状态实现双向通信功能。 

1、RX转TX后第一包数据的发射时长会变长，后面的第二包开始时间恢复正常。 

2、RX转TX时如果CE为高的情况下，芯片会自动进入发射状态（不管有没有数据填入TX FIFO），所以用户在COINFIG 寄存器配成 8E后，需要在10us内写paylaod,否则发出的数据可能不是用户预期的。

### 二、条件说明

    SPI类型：4线spi
    RF速率：250K
    CE模式:  软件CE
    数据长度：8bytes
    频点：2478Mhz
    功率：9dbm
### 三、接口(移植)实现

1、根据实际使用的MCU实现rf.c中延时函数delay_ms()和delay_100us();

2、根据实际使用情况修改rf.c中SPI_init函数

![spi_init](img\spi_init.png)

修改rf.h中RF相关IO口的定义。

<img src="img\io_set.png" alt="io_set" style="zoom:150%;" />

### 四、应用范例

TX端：上电首先设置RF为发射状态，发完一包数据后切换为接收状态，接收5ms时间（5ms包含切换为接收后的稳定时间<1ms），查询是否收到回应数据。收完后再次切换为发射状态，间隔10ms后进入新的发送-接收循环。

![tx](img\tx.png)

RX端：设置为接收状态，轮询是否有数据接收到。收到数据后切换为发射状态，发完数据后切换回接收状态。

![rx](img\rx.png)

逻辑分析仪抓取SPI如下：

![logic](img\logic.png)



### 五、参考文档

《11_XN297L 250Kbps使用说明_V1p1.pdf》