# <center >IRQ使用</center >

### 一、简介

本例程演示xn297l 普通(单向)通信功能，使用IRQ监测RF状态。TX发射数据，RX接收数据。

### 二、条件说明

    SPI类型：4线spi
    RF速率：2M/1M(具体速率选择通过rf.h中宏定义DATA_RATE设置)
    CE模式:  软件CE
    数据长度：8bytes
    频点：2478Mhz
    功率：9dbm
### 三、接口(移植)实现

1、根据实际使用的MCU实现rf.c中延时函数delay_ms()和delay_100us();

2、根据实际使用情况修改rf.c中SPI_init函数

![spi_init](img\spi_init.png)

修改rf.h中RF相关IO口的定义。

<img src="img\io_set.png" alt="io_set" style="zoom:150%;" />

### 四、应用范例

TX端：设置为发射模式，间隔10ms发送一次数据

![tx](img\tx.png)

在RF_TxData函数中，调用RF_WriteBuf(W_TX_PAYLOAD, ucPayload, length)后芯片开始准备发射数据，因为芯片在发射过程中不能频繁操作SPI(会影响到数据发射)，如果不使用IRQ，则需要先计算预估数据发送的时间(常规情况下我们预留1ms时间,发射的时间跟数据长度有关)，再去查询寄存器判断是否发送完成。

<img src="img\RF_TxData.png" alt="RF_TxData" style="zoom:150%;" />

如果使用IRQ,则可以直接查询IRQ电平判断数据什么时候发送结束（避免频繁操作SPI）。另外也可以将IRQ接入到MCU的中断脚。

![RF_TxData_with_irq](img\RF_TxData_with_irq.png)

RX端：设置为接收模式，在接收中直接通过IRQ判断是否有收到数据。

![rx](img\rx.png)

![rx_data](img\rx_data.png)

### 五、参考文档

《02_XN297L 1Mbps软件设计和调试参考_V1p3.pdf》