# <center >XN297L RSSI应用</center >

### 一、简介

本例程演示xn297l  rssi读取应用，包括接收信号前干扰强度以及接收数据的信号强度。

### 二、条件说明

    SPI类型：4线spi
    RF速率：2M/1M(具体速率选择通过rf.h中宏定义DATA_RATE设置)
    CE模式:  软件CE
    数据长度：8bytes
    频点：2478Mhz
    功率：9dbm
### 三、接口(移植)实现

1、根据实际使用的MCU实现rf.c中延时函数delay_ms()和delay_100us();

2、根据实际使用情况修改rf.c中SPI_init函数

![spi_init](img\spi_init.png)

修改rf.h中RF相关IO口的定义。

<img src="img\io_set.png" alt="io_set" style="zoom:150%;" />

### 四、应用范例

上电首先在RF_Init()函数中寄存器 RSSI_EN 和 RSSI_SEL 设置为高，DATAOUT_SEL设置为低， RSSI_Gain_CTR保持默认的值( 即-6dbm衰减，用户可自行设置其它值)。设置后参数如下：

![spi_init](img\rssi_mode_para.png)

初始化完成后，设置为接收模式，之后可从寄存器0x09读取到相关的rssi值。

例程中上电首先读取2400-2483Mhz 频点的干扰强度(为了演示效果，接收模块旁边放置了一个频点为2450Mhz的载波发射模块)，读取数值如下：

![spi_init](img\noise_2450Mhz.png)

从干扰强度值来看，可以看到2450频点值最大，周边几个频点也会存在影响。具体测试出的数值跟 RSSI_Gain_CTR设置有关。

读取环境干扰过后，进入正常接收频点，即2478Mhz，读取接收到数据后的信号强度，如下所示：

![spi_init](img\rev_2478Mhz.png)

### 五、参考文档

01_SDK\2M_1M\4_LINE_SPI\rssi\XN297L RSSI应用.pdf

